
#include <CurieBLE.h>
#include "CurieTimerOne.h"

#ifndef INTERVAL_TIMER
#define INTERVAL_TIMER 1000
#endif

static bool intervalFireOff = false;

BLEService CloudPrimaryService("bfe433cf-6b5e-4368-abab-b0a59666a402");
BLECharacteristic CloudCredentials("bfe433cf-6b5e-4368-abab-b0a59666a403", BLERead | BLEWrite, 64);
BLECharacteristic CloudNotify("bfe433cf-6b5e-4368-abab-b0a59666a404", BLERead | BLEWrite | BLENotify, 64);

void characteristicSubscribed(BLECentral& central, BLECharacteristic& characteristic) {
  // characteristic subscribed event handler
  //Serial.println(F("Characteristic event, subscribed"));
}

void characteristicUnsubscribed(BLECentral& central, BLECharacteristic& characteristic) {
  // characteristic unsubscribed event handler
  //Serial.println(F("Characteristic event, unsubscribed"));
}

void intervalTimerIsr() {
	intervalFireOff = true;
	
}

void setup() {
	Serial.begin(115200);

  Serial.println("REBOOT");

	BLE.begin();
	BLE.setLocalName("Test101");
	BLE.setAdvertisedServiceUuid(CloudPrimaryService.uuid());
	BLE.setDeviceName("Atmosphere Test");
	// add service and characteristics

	CloudPrimaryService.addCharacteristic(CloudCredentials);
	CloudPrimaryService.addCharacteristic(CloudNotify);

	BLE.addService(CloudPrimaryService);

	CurieTimerOne.start(1000 * INTERVAL_TIMER, &intervalTimerIsr);
	BLE.advertise();
}

void doIntervalCheck()
{
	if(intervalFireOff)
	{
		intervalFireOff = false;
		Serial.println("I'm alive!");
	}
}

void loop() {
	doIntervalCheck();
	
	// poll peripheral
	BLEDevice central = BLE.central();

	if(central) 
	{
		if(central.connected())
		{
			BLE.stopAdvertise();
			while(central.connected())
			{
				doIntervalCheck();

			}
			BLE.advertise();
		}
	}
}

