#include "actions.hpp"

// clang-format off
static const char* xml_text = R"(
 <root >
     <BehaviorTree>
        <ReactiveSequence name="sequence">
            <Supervisor name="supervisor"/>
            <SequenceStar name="sequenceStar">
                <MyAsyncAction name="action_A"/>
                <MyAsyncAction name="action_B"/>
            </SequenceStar>
        </ReactiveSequence>
     </BehaviorTree>
 </root>
 )";

// clang-format on

int main()
{
    BehaviorTreeFactory factory;
    factory.registerNodeType<Supervisor>("Supervisor");
    factory.registerNodeType<MyAsyncAction>("MyAsyncAction");

    auto tree = factory.createTreeFromText(xml_text);

    //---------------------------------------
    // keep executin tick until it returns etiher SUCCESS or FAILURE
    while( tree.tickRoot() == NodeStatus::RUNNING)
    {
        std::this_thread::sleep_for( std::chrono::milliseconds(10) );
    }
    return 0;
}