#!/bin/bash
#
# Prepares the DIF and CONF files for experiment.
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
FST=0
KERN=4.1.16
RDIR=/pristine/userspace
CDIR=../conf

# Prepare vlan .dif files.
#
while read line
do
	NAME=$(echo $line | awk '{print $1}')
	ETH=$(echo $line | awk '{print $2}')
	VLAN=$(echo $line | awk '{print $3}')	
	
	if [ -z $NAME ]; then
		continue
	fi
	
	echo
	echo "Preparing dif for $NAME ($ETH, $VLAN)..."
	echo "{" > $CDIR/$VLAN.$NAME.dif
	echo "	\"difType\" : \"shim-eth-vlan\"," >> $CDIR/$VLAN.$NAME.dif
	echo "	\"configParameters\" : " >> $CDIR/$VLAN.$NAME.dif
	echo "	{" >> $CDIR/$VLAN.$NAME.dif
	echo "		\"interface-name\" : \"$ETH\"" >> $CDIR/$VLAN.$NAME.dif
	echo "	}" >> $CDIR/$VLAN.$NAME.dif
	echo "}" >> $CDIR/$VLAN.$NAME.dif
done < network.txt

# Prepare .conf file per node.
#
while read line
do
	NAME=$(echo $line | awk '{print $1}')
	
	if [ -z $NAME ]; then
		continue
	fi
	
	echo
	echo "Preparing .conf for node $NAME..."
	
	echo "{" > $CDIR/$NAME.conf
	echo "	\"configFileVersion\" : \"1.4.1\"," >> $CDIR/$NAME.conf
	echo "	\"localConfiguration\" : " >> $CDIR/$NAME.conf
	echo "	{" >> $CDIR/$NAME.conf
	echo "		\"installationPath\" : \"$RDIR/bin\"," >> $CDIR/$NAME.conf
	echo "		\"libraryPath\" : \"$RDIR/lib\"," >> $CDIR/$NAME.conf
	echo "		\"logPath\" : \"$RDIR/log\"," >> $CDIR/$NAME.conf
#	echo "		\"consolePort\" : 32766," >> $CDIR/$NAME.conf
	echo "		\"consoleSocket\" : \"$RDIR/var/ipcm-console.sock\", " >> $CDIR/$NAME.conf
	echo "		\"pluginsPaths\": [" >> $CDIR/$NAME.conf
	echo "			\"$RDIR/lib/rinad/ipcp\"," >> $CDIR/$NAME.conf
	echo "			\"/lib/modules/$KERN/extra\"" >> $CDIR/$NAME.conf
        echo "	]" >> $CDIR/$NAME.conf
	echo "	}," >> $CDIR/$NAME.conf
#	echo "	\"applicationToDIFMappings\" : " >> $CDIR/$NAME.conf
#	echo "	[]," >> $CDIR/$NAME.conf
	echo "	\"ipcProcessesToCreate\" :"  >> $CDIR/$NAME.conf
	echo "	["  >> $CDIR/$NAME.conf
	
	echo "    Setting shims..."
	
	while read line
	do
		NOD=$(echo $line | awk '{print $1}')
		ETH=$(echo $line | awk '{print $2}')
		VLAN=$(echo $line | awk '{print $3}')
	
		if [ "$NAME" == "$NOD" ];
		then
			if [ $FST -eq 0 ];
			then
				FST=1
			else
				echo "		," >> $CDIR/$NAME.conf
			fi
		
			echo "		{" >> $CDIR/$NAME.conf
			echo "			\"type\" : \"shim-eth-vlan\"," >> $CDIR/$NAME.conf
			echo "			\"apName\" : \"$NOD.$VLAN\"," >> $CDIR/$NAME.conf
			echo "			\"apInstance\" : \"1\"," >> $CDIR/$NAME.conf
			echo "			\"difName\" : \"$VLAN\"" >> $CDIR/$NAME.conf
			echo "		}" >> $CDIR/$NAME.conf
		fi
		
	done < network.txt
	
	FST=0
	
	#
	# Personalize here the ipcp common to all the nodes.
	#
	
	echo "		," >> $CDIR/$NAME.conf
	echo "		{" >> $CDIR/$NAME.conf
	echo "			\"type\" : \"normal-ipc\"," >> $CDIR/$NAME.conf
	echo "			\"apName\" : \"$NAME.dc\"," >> $CDIR/$NAME.conf
	echo "			\"apInstance\" : \"1\"," >> $CDIR/$NAME.conf
	echo "			\"difName\" : \"dc\"," >> $CDIR/$NAME.conf
	echo "			\"difsToRegisterAt\" : [" >> $CDIR/$NAME.conf
	
	echo "    Setting registrations..."
	
	while read line
	do
		NOD=$(echo $line | awk '{print $1}')
		VLAN=$(echo $line | awk '{print $3}')
	
		if [ "$NAME" == "$NOD" ];
		then
			if [ $FST -eq 0 ];
			then
				FST=1
			else
				echo "			," >> $CDIR/$NAME.conf
			fi
			 
			echo "			\"$VLAN\"" >> $CDIR/$NAME.conf
		fi
		
	done < network.txt
	
	FST=0
	
	echo "		]" >> $CDIR/$NAME.conf
	echo "		}" >> $CDIR/$NAME.conf
	echo "	]," >> $CDIR/$NAME.conf
	echo "	\"difConfigurations\" : [" >> $CDIR/$NAME.conf
	
	echo "    Setting configurations..."
	
	while read line
	do
		NOD=$(echo $line | awk '{print $1}')
		VLAN=$(echo $line | awk '{print $3}')
	
		if [ "$NAME" == "$NOD" ];
		then
			if [ $FST -eq 0 ];
			then
				FST=1
			else
				echo "	," >> $CDIR/$NAME.conf
			fi
			 
			echo "	{" >> $CDIR/$NAME.conf
			echo "		\"name\" : \"$VLAN\"," >> $CDIR/$NAME.conf
			echo "		\"template\" : \"$VLAN.$NOD.dif\"" >> $CDIR/$NAME.conf
			echo "	}" >> $CDIR/$NAME.conf
		fi
		
	done < network.txt
	
	FST=0
	
	echo "	," >> $CDIR/$NAME.conf
	echo "	{" >> $CDIR/$NAME.conf
	echo "		\"name\" : \"dc\"," >> $CDIR/$NAME.conf
	echo "		\"template\" : \"dc.dif\"" >> $CDIR/$NAME.conf
	echo "	}]" >> $CDIR/$NAME.conf
	echo "}" >> $CDIR/$NAME.conf
	
done < access.txt