#!/bin/bash
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
TDIR=/share/projects/pristine/testbed/conf
RDIR=/pristine

if [ $# -eq 0 ]; then
	while read line
	do
		NAME=$(echo $line | awk '{print $1}')
		TARGET=$(echo $line | awk '{print $2}')	
		UNAME=$(echo $line | awk '{print $3}')	
		echo
		echo
		echo "Copying configurations to $NAME"
		ssh -n $UNAME@$TARGET "sudo rm -r $RDIR/conf/*"
		scp -r $TDIR $UNAME@$TARGET:$RDIR
	done < access.txt
	
else
	TARGET=$(cat access.txt | awk -v T=$1 '$1 == T {print $2}')
	UNAME=$(cat access.txt | awk -v T=$1 '$1 == T {print $3}')
	echo
	echo
	echo "Copying configurations to $1"
	ssh -n $UNAME@$TARGET "sudo rm -r $RDIR/conf/*"
	scp -r $TDIR $UNAME@$TARGET:$RDIR
fi
