#!/bin/bash
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
RDIR=/pristine

if [ $# -eq 0 ]; then
	while read line
	do
		NAME=$(echo $line | awk '{print $1}')
		UNAME=$(cat access.txt | awk -v T=$NAME '$1 == T {print $3}')
		TARGET=$(cat access.txt | awk -v T=$NAME '$1 == T {print $2}')
		ID=$(echo $line | awk '{print $2}')
		DIF=$(echo $line | awk '{print $3}')
		SDIF=$(echo $line | awk '{print $4}')
		IPCN=$(echo $line | awk '{print $5}')
		IPCI=$(echo $line | awk '{print $6}')
		echo
		echo
		echo "Enrolling $NAME node..."
		ssh -n $UNAME@$TARGET "sudo sh $RDIR/scripts/generic-enroll-to.sh $ID $DIF $SDIF $IPCN $IPCI" 
	done < enroll.txt
else
	NAME=$1
	UNAME=$(cat access.txt | awk -v T=$NAME '$1 == T {print $3}')
	TARGET=$(cat access.txt | awk -v T=$NAME '$1 == T {print $2}')
	ID=$(cat enroll.txt | awk -v T=$NAME '$1 == T {print $2}')
	DIF=$(cat enroll.txt | awk -v T=$NAME '$1 == T {print $3}')
	SDIF=$(cat enroll.txt | awk -v T=$NAME '$1 == T {print $4}')
	IPCN=$(cat enroll.txt | awk -v T=$NAME '$1 == T {print $5}')
	IPCI=$(cat enroll.txt | awk -v T=$NAME '$1 == T {print $6}')
	echo
	echo
	echo "Enrolling $NAME node..."
	ssh -n $UNAME@$TARGET "sudo sh $RDIR/scripts/generic-enroll-to.sh $ID $DIF $SDIF $IPCN $IPCI"
fi