#!/bin/bash
#
# Gets experiment configuration from one of the experiment nodes.
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
NODE=$1
L=0
W=0
STOPL="# lans: vname,mask,cost"

# Be sure that you got the following arguments:
#	1 - Node name where to get configuration info.
#
if [ $# -ne 1 ];
then
	echo "Usage: net-resolution.sh <node name>"
	exit
fi

UNAME=$(cat access.txt | awk -v T=$NODE '$1 == T {print $3}')
TARGET=$(cat access.txt | awk -v T=$NODE '$1 == T {print $2}')

echo
echo
echo "Getting nodes configuration..."
echo
ssh -n $UNAME@$TARGET "cat /var/emulab/boot/topomap" > tmap.txt

# Fill structures with data read.
#
while read line
do
	L=$((L+1))

	# Skip the first line.
	#
	if [ $((L)) -eq 1 ];
	then
		cat /dev/null > net-pre.txt
		continue
	fi
	
	# Link processing.
	#
	if [ "$line" = "$STOPL" ]
	then
		break
	fi

	# Analyse that string.
	#
	IFS=','
	for word in $line;
	do
		W=$((W+1))
		
		# Got that node name.
		#
		if [ $((W)) -eq 1 ];
		then
			NNAME=$word
			continue
		fi
		
		# Second word to futher tokenize.
		#
		IFS=' '
		for wprd in $word;
		do
			# Daamn, last tokenization of the word.
			#
			IFS=':'
			TKS=( $wprd )
			 
			VLAN=$(echo ${TKS[0]} | cut -c 5-)
#			VLAN=${TKS[0]} 
			IPA=${TKS[1]}
			
			echo "$NNAME $VLAN $IPA" >> net-pre.txt
		done
	done
	
	W=0

done < tmap.txt

cat /dev/null > network.txt

# Last step, now get the interfaces...
#
while read line
do
	IFS=' '
	TKS=($line)
	
	TARGET=$(cat access.txt | awk -v T=${TKS[0]} '$1 == T {print $2}')
	IFACE=$(ssh -n $UNAME@$TARGET "cat /var/emulab/boot/ifmap")
	ETH=$(echo $IFACE | awk -v T=${TKS[2]} '$2 == T {print $1}')
	
	echo configuring VLAN ${TKS[1]} on interface $ETH of node ${TKS[0]}
	echo ${TKS[0]} $ETH ${TKS[1]} ${TKS[2]} >> network.txt
	
done < net-pre.txt

# Remove the temporary files.
#
rm net-pre.txt
rm tmap.txt
