#!/bin/bash
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
SCRIPTS=/pristine/scripts

if [ $# -eq 0 ]; then
	while read line
	do
		INT=$(echo $line | awk '{print $2}')
		VLAN=$(echo $line | awk '{print $3}')
		NAME=$(echo $line | awk '{print $1}')
		UNAME=$(cat access.txt | awk -v T=$NAME '$1 == T {print $3}')
		TARGET=$(cat access.txt | awk -v T=$NAME '$1 == T {print $2}')
		echo
		echo
		echo "Preparing interface for node $NAME..."
		ssh -n $UNAME@$TARGET "sudo sh $SCRIPTS/interface-setup.sh $INT $VLAN"
	done < network.txt
	
else
	INT=$(cat network.txt | awk -v T=$1 '$1 == T {print $2}')
	VLAN=$(cat network.txt | awk -v T=$1 '$1 == T {print $3}')
	NAME=$1
	UNAME=$(cat access.txt | awk -v T=$NAME '$1 == T {print $3}')
	TARGET=$(cat access.txt | awk -v T=$NAME '$1 == T {print $2}')
	echo
	echo
	echo "Preparing interface for node $NAME..."
	ssh -n $UNAME@$TARGET "sudo sh $SCRIPTS/interface-setup.sh $INT $VLAN"
fi