#!/bin/bash
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
CDIR=/pristine/conf
SDIR=/pristine/scripts

if [ $# -eq 0 ]; then
	while read line
	do
		NAME=$(echo $line | awk '{print $1}')
		UNAME=$(echo $line | awk '{print $3}')
		TARGET=$(echo $line | awk '{print $2}')	
		echo
		echo
		echo "Preparing $NAME node..."
		ssh -n $UNAME@$TARGET "sudo sh $SDIR/launch-ipcm-generic.sh $CDIR/$NAME.conf $NAME"
	done < access.txt
else
	NAME=$1
	UNAME=$(cat access.txt | awk -v T=$1 '$1 == T {print $3}')
	TARGET=$(cat access.txt | awk -v T=$1 '$1 == T {print $2}')
	echo
	echo
	echo "Preparing $1 node..."
	ssh -n $UNAME@$TARGET "sudo sh $SDIR/launch-ipcm-generic.sh $CDIR/$NAME.conf $NAME"
fi