#!/bin/bash
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#

if [ $# -eq 1 ]; then
	while read line
	do
		NAME=$(echo $line | awk '{print $1}')
		UNAME=$(echo $line | awk '{print $3}')
		TARGET=$(echo $line | awk '{print $2}')
		echo
		echo
		echo "Running script $1 for node $NAME..."
		ssh -n $UNAME@$TARGET "$1"
	done < access.txt
else
	NAME=$1
	UNAME=$(cat access.txt | awk -v T=$NAME '$1 == T {print $3}')
	TARGET=$(cat access.txt | awk -v T=$NAME '$1 == T {print $2}')
	echo
	echo
	echo "Running script $2 for node $1..."
	ssh -n $UNAME@$TARGET "$2"
fi