#!/bin/bash
#
# Prepare a network interface with VLAN configuration compatible to RINA.
# 1 - the eth interface to use.
# 2 - the vlan id to use.
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
ETH=$1
VLAN=$2

echo "Setting up interface $1..."

# Problem solving, only for vWall.
#
ethtool -K $ETH rxvlan off txvlan off

# Configure and wake up VLAN over the desired eth interface.
#
ip link add link $ETH name $ETH.$VLAN type vlan id $VLAN
ip link set dev $ETH up
ip link set dev $ETH.$VLAN up
