#!/bin/bash
#
# Prepare to VLAN testing in a generic case.
# This script need 3 arguments, which are:
# 1 - the IPC Manager configuration file.
# 2 - node qualifier
#
# Author: Kewin Rausch <kewin.rausch@create-net.org>
#
SANDBOX=/pristine/userspace
SCRIPTS=/pristine/scripts
CONF=$1

# Clean previous kernel messages; we're starting a new test.
#
sh $SCRIPTS/clean-logs.sh

rmmod ecn
rmmod cdrr
rmmod pffb
rmmod multipath

# Load RINA modules.
#
modprobe shim-eth-vlan
modprobe rina-default-plugin
modprobe normal-ipcp

# Run the IPC Manager if the right configuration file exists.
#
if [ -f $CONF ]; then
	# Log the ipcm NOT on the current console.
	#
	$SANDBOX/bin/ipcm -c $CONF > $SANDBOX/bin/$2.ipcm.log &
else
	echo "Error: no IPC Manager configuration file found!"
fi