"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@angular/core");
var utils = require("utils/utils");
var shared_1 = require("../../shared");
var shared_2 = require("../../shared");
var page_1 = require("ui/page");
var observable_array_1 = require("data/observable-array");
var application_settings_1 = require("application-settings");
var connectivity_1 = require("connectivity");
var router_1 = require("@angular/router");
var app = require("application");
var ImageSourceModule = require("image-source");
var image_source_1 = require("image-source");
var core_2 = require("@ngx-translate/core");
var ChatPrivateList = (function () {
    function ChatPrivateList(Date, messageText, groupName, groupId, userName, userId, msgUnreadCount) {
        this.Date = Date;
        this.messageText = messageText;
        this.groupName = groupName;
        this.groupId = groupId;
        this.userName = userName;
        this.userId = userId;
        this.msgUnreadCount = msgUnreadCount;
    }
    return ChatPrivateList;
}());
var AllChatUser = AllChatUser_1 = (function () {
    function AllChatUser(page, loginService, hieberService, router, translate) {
        var _this = this;
        this.page = page;
        this.loginService = loginService;
        this.hieberService = hieberService;
        this.router = router;
        this.isVisible = true;
        this.chatList = [];
        //Activity indicatior
        this.isAuthenticating = false;
        this.load();
        this.dismissKeyBoard();
        this.defaultImage = new image_source_1.ImageSource();
        this.defaultImage = ImageSourceModule.fromResource("login_icon");
        translate.get('HOME.internet_connection', { value: '' }).subscribe(function (res) {
            _this.internet_connection_dialog = res;
        });
    }
    // Hide Keypad.
    AllChatUser.prototype.dismissKeyBoard = function () {
        if (this.isAndroid) {
            try {
                var activity = app.android.foregroundActivity;
                var Context = app.android.currentContext;
                var inputManager = app.android.context.getSystemService(Context.INPUT_METHOD_SERVICE);
                inputManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), Context.view.inputmethod.InputMethodManager.HIDE_NOT_ALWAYS);
            }
            catch (err) {
                console.log(AllChatUser_1.CLASS_NAME + err);
            }
        }
    };
    AllChatUser.prototype.ngAfterContentInit = function () {
        var _this = this;
        // set the Timer to get updates while on this component
        this.timerForUpdateChatList = setInterval(function () { return _this.load(); }, 3300);
    };
    AllChatUser.prototype.getUpdateChatList = function () {
        this.load();
    };
    AllChatUser.prototype.ngOnInit = function () {
        this.load();
    };
    AllChatUser.prototype.ngOnDestroy = function () {
        // clearInterval when component is destroy
        clearInterval(this.timerForUpdateChatList);
    };
    AllChatUser.prototype.load = function () {
        var _this = this;
        this.isAuthenticating = true;
        if (connectivity_1.getConnectionType() === connectivity_1.connectionType.none) {
            clearInterval(this.timerForUpdateChatList);
            shared_2.alert(this.internet_connection_dialog);
            this.isAuthenticating = false;
            return;
        }
        this.hieberService.getChatConversationAll()
            .subscribe(function (data) {
            var resultData = JSON.parse(JSON.stringify(data));
            _this.chatList = [];
            _this.chat = new observable_array_1.ObservableArray(_this.chatList);
            for (var i = 0; i < resultData.length; i++) {
                var getData;
                if (resultData[i].IsGroup === true) {
                    getData = { "Date": (new Date(resultData[i].Date).getTime() + new Date(resultData[i].Date).getTimezoneOffset() * 60 * 1000), "messageText": resultData[i].Message.Text, "groupName": resultData[i].Group.Name, "userItem": "collapsed", "grpItem": "visible", "groupId": resultData[i].Group.Id, "msgUnread": resultData[i].UnreadMessageCount, "userName": "", "userId": "", "grpNumber": true, "profileimage": _this.defaultImage };
                    if (getData.msgUnread == 0) {
                        getData.msgUnread = "";
                        getData.grpNumber = false;
                    }
                }
                else {
                    if (resultData[i].User.Picture != null) {
                        var src = new image_source_1.ImageSource();
                        src.loadFromBase64(resultData[i].User.Picture.File);
                        getData = { "Date": (new Date(resultData[i].Date).getTime() + new Date(resultData[i].Date).getTimezoneOffset() * 60 * 1000), "messageText": resultData[i].Message.Text, "groupName": "", "userItem": "visible", "grpItem": "collapsed", "groupId": "", "msgUnread": resultData[i].UnreadMessageCount, "userName": resultData[i].User.Name, "userId": resultData[i].User.UserID, "grpNumber": true, "profileimage": src };
                    }
                    else {
                        getData = { "Date": (new Date(resultData[i].Date).getTime() + new Date(resultData[i].Date).getTimezoneOffset() * 60 * 1000), "messageText": resultData[i].Message.Text, "groupName": "", "userItem": "visible", "grpItem": "collapsed", "groupId": "", "msgUnread": resultData[i].UnreadMessageCount, "userName": resultData[i].User.Name, "userId": resultData[i].User.UserID, "grpNumber": true, "profileimage": _this.defaultImage };
                    }
                    if (getData.msgUnread == 0) {
                        getData.msgUnread = "0";
                        getData.grpNumber = false;
                    }
                }
                _this.chatList.push(getData);
            }
            _this.chat = new observable_array_1.ObservableArray(_this.chatList);
            _this.chat.sort(function (left, right) { return left.Date == right.Date ? 0 : (left.Date > right.Date ? -1 : 1); });
        }, function (error) {
            _this.isAuthenticating = false;
            //  alert("Unfortunately we could not get chat..");
        }, function () {
            _this.isAuthenticating = false;
            // console.log(AllChatUser.CLASS_NAME + "get chat user works fine.");
        });
    };
    // on Chat item selected 
    AllChatUser.prototype.chatItemSelected = function (args) {
        this.senderID = application_settings_1.getNumber("userID");
        var data = args.view.bindingContext;
        data.msgUnread = "0";
        if (data.userId == 0) {
            var navigationExtras = {
                queryParams: {
                    "groupName": data.groupName,
                    "chatGroupId": data.groupId
                }
            };
            this.router.navigate(["/tc-group-chat"], navigationExtras);
        }
        else {
            var navigationExtras = {
                queryParams: {
                    "OtherName": data.userName,
                    "chatUserId": data.userId,
                }
            };
            this.router.navigate(["/tc-chat"], navigationExtras);
        }
    };
    // The following trick makes the background color of each cell
    // in the UITableView transparent as it’s created.
    AllChatUser.prototype.makeBackgroundTransparent = function (args) {
        var cell = args.ios;
        if (cell) {
            // support XCode 8
            cell.backgroundColor = utils.ios.getter(UIColor, UIColor.clearColor);
        }
    };
    return AllChatUser;
}());
AllChatUser.CLASS_NAME = "AllChatUser = ";
__decorate([
    core_1.Input(),
    __metadata("design:type", Object)
], AllChatUser.prototype, "row", void 0);
AllChatUser = AllChatUser_1 = __decorate([
    core_1.Component({
        selector: "gr-all-chat-list",
        templateUrl: "main/chatlist/allChatUser.component.html",
        styleUrls: ["main/main-common.css"],
        providers: [shared_1.HieberService]
    }),
    __metadata("design:paramtypes", [page_1.Page, shared_1.LoginService, shared_1.HieberService, router_1.Router, core_2.TranslateService])
], AllChatUser);
exports.AllChatUser = AllChatUser;
var AllChatUser_1;
//# sourceMappingURL=data:application/json;base64,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