"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@angular/core");
var utils = require("utils/utils");
var shared_1 = require("../../shared");
var shared_2 = require("../../shared");
var page_1 = require("ui/page");
var observable_array_1 = require("data/observable-array");
var application_settings_1 = require("application-settings");
var router_1 = require("@angular/router");
var connectivity_1 = require("connectivity");
var app = require("application");
var core_2 = require("@ngx-translate/core");
var ChatPrivateList = (function () {
    function ChatPrivateList(name, userid, messageText, Date) {
        this.name = name;
        this.userid = userid;
        this.messageText = messageText;
        this.Date = Date;
    }
    return ChatPrivateList;
}());
var PrivateChatUser = PrivateChatUser_1 = (function () {
    function PrivateChatUser(page, loginService, hieberService, router, translate) {
        var _this = this;
        this.page = page;
        this.loginService = loginService;
        this.hieberService = hieberService;
        this.router = router;
        this.isVisible = true;
        this.chatList = [];
        this.chatListLengthCheck = 0;
        //Activity indicatior
        this.isAuthenticating = false;
        this.load();
        this.dismissKeyBoard();
        translate.get('HOME.internet_connection', { value: '' }).subscribe(function (res) {
            _this.internet_connection_dialog = res;
        });
    }
    // Hide Keypad.
    PrivateChatUser.prototype.dismissKeyBoard = function () {
        if (this.isAndroid) {
            try {
                var activity = app.android.foregroundActivity;
                var Context = app.android.currentContext;
                var inputManager = app.android.context.getSystemService(Context.INPUT_METHOD_SERVICE);
                inputManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), Context.view.inputmethod.InputMethodManager.HIDE_NOT_ALWAYS);
            }
            catch (err) {
                console.log(PrivateChatUser_1.CLASS_NAME + err);
            }
        }
    };
    PrivateChatUser.prototype.ngAfterContentInit = function () {
        var _this = this;
        // set the Timer to get updates while on this component
        this.timerForUpdateChatList = setInterval(function () { return _this.load(); }, 3300);
    };
    PrivateChatUser.prototype.ngOnInit = function () {
        this.load();
    };
    PrivateChatUser.prototype.ngOnDestroy = function () {
        // clearInterval when component is destroy
        clearInterval(this.timerForUpdateChatList);
    };
    PrivateChatUser.prototype.load = function () {
        var _this = this;
        this.isAuthenticating = true;
        if (connectivity_1.getConnectionType() === connectivity_1.connectionType.none) {
            clearInterval(this.timerForUpdateChatList);
            shared_2.alert(this.internet_connection_dialog);
            this.isAuthenticating = false;
            return;
        }
        this.hieberService.getChatUser()
            .subscribe(function (data) {
            var resultData = JSON.parse(JSON.stringify(data));
            _this.lengthNumberSave = resultData.length;
            //   if(this.chatListLengthCheck == this.lengthNumberSave){
            //     console.log(PrivateChatUser.CLASS_NAME + "length matched");
            //     return;
            //   }
            _this.chatList = [];
            _this.chat = new observable_array_1.ObservableArray(_this.chatList);
            _this.chatListLengthCheck = _this.lengthNumberSave;
            for (var i = 0; i < JSON.parse(JSON.stringify(data)).length; i++) {
                var resultChat = JSON.parse(JSON.stringify(data));
                var chatData = { "name": resultChat[i].User.Name, "userid": resultChat[i].User.UserID, "messageText": resultChat[i].Message.Text, "Date": (new Date(resultChat[i].Message.Date).getTime() + new Date(resultChat[i].Message.Date).getTimezoneOffset() * 60 * 1000), "msgUnread": resultData[i].UnreadMessageCount, "msgNumber": true };
                if (chatData.msgUnread == 0) {
                    chatData.msgUnread = "0";
                    chatData.msgNumber = false;
                }
                _this.chatList.push(chatData);
            }
            _this.chat = new observable_array_1.ObservableArray(_this.chatList);
            for (var i = 0; i < JSON.parse(JSON.stringify(data)).length; i++) {
                _this.chat.sort(function (left, right) { return left.Date == right.Date ? 0 : (left.Date > right.Date ? -1 : 1); });
            }
        }, function (error) {
            _this.isAuthenticating = false;
            //   alert("Unfortunately we could not get chat..");
        }, function () {
            _this.isAuthenticating = false;
            // console.log(PrivateChatUser.CLASS_NAME + "get chat user works fine.");
        });
    };
    // on Chat item selected detail screen open
    PrivateChatUser.prototype.chatItemSelected = function (args) {
        this.senderID = application_settings_1.getNumber("userID", this.senderID);
        var data = args.view.bindingContext;
        var navigationExtras = {
            queryParams: {
                "OtherName": data.name,
                "chatUserId": data.userid,
            }
        };
        this.router.navigate(["/tc-chat"], navigationExtras);
    };
    // The following trick makes the background color of each cell
    // in the UITableView transparent as it’s created.
    PrivateChatUser.prototype.makeBackgroundTransparent = function (args) {
        var cell = args.ios;
        if (cell) {
            // support XCode 8
            cell.backgroundColor = utils.ios.getter(UIColor, UIColor.clearColor);
        }
    };
    return PrivateChatUser;
}());
PrivateChatUser.CLASS_NAME = "PrivateChatUser = ";
__decorate([
    core_1.Input(),
    __metadata("design:type", Object)
], PrivateChatUser.prototype, "row", void 0);
PrivateChatUser = PrivateChatUser_1 = __decorate([
    core_1.Component({
        selector: "gr-chat-list",
        templateUrl: "main/chatlist/privateChatUser.component.html",
        styleUrls: ["main/main-common.css"],
        providers: [shared_1.HieberService]
    }),
    __metadata("design:paramtypes", [page_1.Page, shared_1.LoginService, shared_1.HieberService, router_1.Router, core_2.TranslateService])
], PrivateChatUser);
exports.PrivateChatUser = PrivateChatUser;
var PrivateChatUser_1;
//# sourceMappingURL=data:application/json;base64,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