package com.github.ryanholdren.example;

import com.github.pgasync.ConnectionPool;
import com.github.pgasync.ConnectionPoolBuilder;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import static com.opentable.db.postgres.embedded.EmbeddedPostgres.start;
import java.io.IOException;
import java.time.Instant;
import static java.time.Instant.parse;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.postgresql.ds.PGSimpleDataSource;

public class TimeZoneTest {

	private static final String SQL = "SELECT TIMESTAMP WITH TIME ZONE '2004-10-19T10:23:54Z' AS output;";
	private static final Instant EXPECTED = parse("2004-10-19T10:23:54Z");

	@Test
	public void test() throws IOException {
		try (final EmbeddedPostgres postgres = start()) {
			final PGSimpleDataSource database = (PGSimpleDataSource) postgres.getPostgresDatabase();
			final ConnectionPool pool = new ConnectionPoolBuilder()
				.hostname("localhost")
				.port(postgres.getPort())
				.database(database.getDatabaseName())
				.username(database.getUser())
				.password(database.getPassword())
				.build();
			final Instant actual = pool.queryRows(SQL).map(row -> {
				return row.getTimestamp(0).toInstant();
			}).toBlocking().first();
			assertEquals(EXPECTED, actual);
		}
	}

}
