

#include <ArduinoRS485.h> 
#include <ArduinoModbus.h>

const int numCoils = 10;
const int numDiscreteInputs = 10;
const int numHoldingRegisters = 10;
const int numInputRegisters = 10;

void setup() {
  Serial.begin(9600);
  while (!Serial);
  //pinMode(13,OUTPUT);
  //pinMode(2,OUTPUT);
  Serial.println("Modbus RTU Server Kitchen Sink");

  
  if (!ModbusRTUServer.begin(42, 9600)) {
    Serial.println("Failed to start Modbus RTU Server!");
    while (1);
  }

  
  ModbusRTUServer.configureCoils(0x00, numCoils);

  
  ModbusRTUServer.configureDiscreteInputs(0x00, numDiscreteInputs);

 
  ModbusRTUServer.configureHoldingRegisters(0x00, numHoldingRegisters);

 
  ModbusRTUServer.configureInputRegisters(0x00, numInputRegisters);
}

void loop() { 
 // digitalWrite(13,LOW);
  //digitalWrite(2,LOW);
//  if (Serial.available()){  
//  
//  digitalWrite(2,HIGH);
//  }
//  else { digitalWrite(2,LOW);}
  
  ModbusRTUServer.poll();
int coilStatus = ModbusRTUServer.coilRead(0x01);
  
  for (int i = 0; i < numCoils; i++) {
    int coilValue = ModbusRTUServer.coilRead(i);

    ModbusRTUServer.discreteInputWrite(i, coilValue);
  }
  

//  if (coilStatus) {
//   
//    digitalWrite(13, HIGH);
//    delay(45);
//    digitalWrite(13, LOW);
//    delay(45);
//    digitalWrite(13, HIGH);
//    delay(45);
//    digitalWrite(13, HIGH);
//    delay(45);
//    digitalWrite(13, LOW);
//    delay(45);
//    digitalWrite(13, HIGH);
//  }
  
  
  for (int i = 0; i < numHoldingRegisters; i++) {
    long holdingRegisterValue = ModbusRTUServer.holdingRegisterRead(i);

    ModbusRTUServer.inputRegisterWrite(i, holdingRegisterValue);
  }
}
