/*
  Rui Santos
  Complete project details at https://RandomNerdTutorials.com/esp8266-nodemcu-date-time-ntp-client-server-arduino/
  
  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files.
  
  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  Generic ESP8266 Module      OK
  Wemos D1 R1                 OK
  LOLIN (WEMOS) D1 R2 & mini  OK

  + Temperatura, Umidità e display 128X32  ---> sbaglia i minuti dopo un po'
  
*/

#include <ESP8266WiFi.h>
#include <NTPClient.h>
#include <WiFiUdp.h>
#include <Adafruit_Sensor.h>
#include <DHT.h>

////////////////////////////////////////   Display
#include <Wire.h>
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
// 0X3C+SA0 - 0x3C or 0x3D
#define I2C_ADDRESS 0x3C

// Define proper RST_PIN if required.
#define RST_PIN -1


SSD1306AsciiWire oled;
////////////////////////////////////////

// Replace with your network credentials
const char *ssid     = "SIP-2";
const char *password = "ambarabaciccicocco";

#define DHTTYPE    DHT11   
#define DHTPIN 14     // Digital pin connected to the DHT sensor  D5 = GP-IO 14
//#define DHTTYPE    DHT22  
DHT dht(DHTPIN, DHTTYPE); 

// current temperature & humidity, updated in loop()
float t = 0.0;
float h = 0.0;
unsigned long previousMillis = 0;    // will store last time DHT was updated

// Updates DHT readings every 30 seconds
const long interval = 30000;  
unsigned long currentMillis = millis();

// Define NTP Client to get time
WiFiUDP ntpUDP;
//NTPClient timeClient(ntpUDP, "pool.ntp.org");
NTPClient timeClient(ntpUDP, "192.168.1.250"); //

//Week Days
//String weekDays[7]={"Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"};
String weekDays[7]={"Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"};

//Month names
String months[12]={"Gennaio", "Febbraio", "Mazo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"};

int currentSecond0 = 0;
///////////////////////////////////////////////////////////////////////////////////////////////////////////
void setup() {

  /////////////////////////////////////Display
    Wire.begin();
  Wire.setClock(400000L);

  #if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
  #else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
  #endif // RST_PIN >= 0
  /////////////////////////////////////
  
  pinMode(LED_BUILTIN, OUTPUT);
  // Initialize Serial Monitor
  Serial.begin(115200);

   dht.begin();  // Inizializza il sensore di temperatura
  
  // Connect to Wi-Fi
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
   Serial.println(WiFi.localIP());
   
// Initialize a NTPClient to get time
  timeClient.begin();
  // Set offset time in seconds to adjust for your timezone, for example:
  // GMT +1 = 3600
  // GMT +8 = 28800
  // GMT -1 = -3600
  // GMT 0 = 0
  timeClient.setTimeOffset(-3600 * 3); // Paraguay   si può cambiare dinamicamente
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
void loop() {
 

  //////////
  currentMillis = millis();
  if (currentMillis - previousMillis >= interval) {
    // save the last time you updated the DHT values
    previousMillis = currentMillis;
    // Read temperature as Celsius (the default)
    float newT = dht.readTemperature();
    // Read temperature as Fahrenheit (isFahrenheit = true)
    //float newT = dht.readTemperature(true);
    // if temperature read failed, don't change t value
    if (isnan(newT)) {
      Serial.println("Failed to read Temperature from DHT sensor!");
    }
    else {
      t = newT;
      Serial.print(t);
      Serial.println(" ºC");
    }
    // Read Humidity
    float newH = dht.readHumidity();
    // if humidity read failed, don't change h value 
    if (isnan(newH)) {
      Serial.println("Failed to read Humidity from DHT sensor!");
    }
    else {
      h = newH;
      Serial.print(h);
      Serial.println(" %");
    }
  }
  /////////


  timeClient.update();
   
  unsigned long epochTime = timeClient.getEpochTime();
//  Serial.print("Epoch Time: ");
//  Serial.println(epochTime);
  
  String formattedTime = timeClient.getFormattedTime();
//  Serial.print("Formatted Time: ");
//  Serial.println(formattedTime);  

  int currentHour = timeClient.getHours();
//  Serial.print("Hour: ");
//  Serial.println(currentHour);  

  int currentMinute = timeClient.getMinutes();
//  Serial.print("Minutes: ");
//  Serial.println(currentMinute); 
   
  int currentSecond = timeClient.getSeconds();
//  Serial.print("Seconds: ");
//  Serial.println(currentSecond);  
   

  String weekDay = weekDays[timeClient.getDay()];
//  Serial.print("Week Day: ");
//  Serial.println(timeClient.getDay());
//  Serial.println(weekDay);    

  //Get a time structure
  struct tm *ptm = gmtime ((time_t *)&epochTime); 

  int monthDay = ptm->tm_mday;
//  Serial.print("Month day: ");
//  Serial.println(monthDay);

  int currentMonth = ptm->tm_mon+1;
//  Serial.print("Month: ");
//  Serial.println(currentMonth);

  String currentMonthName = months[currentMonth-1];
//  Serial.print("Month name: ");
//  Serial.println(currentMonthName);

  int currentYear = ptm->tm_year+1900;
//  Serial.print("Year: ");
//  Serial.println(currentYear);

  //Print complete date:
  String currentDate = String(monthDay)+ "-" + String(currentMonth) + "-" + String(currentYear); ;
  //Serial.print("Data: ");
  //Serial.println(currentDate);
  // Serial.println (String(weekDay) + "  " +String(monthDay) + " " + currentMonthName  + " " + String(currentYear)  );

//  Serial.println("");
if (currentSecond != currentSecond0) {

      Serial.print (String(weekDay) + "  " +String(monthDay) + " " + currentMonthName  + " " + String(currentYear)  );
      Serial.print("  Ore ");
      Serial.print(currentHour);
      Serial.print(":");
      Serial.print(twoDigits(currentMinute));
      Serial.print(":");
      Serial.println(twoDigits(currentSecond)); 
     
   //  mettere qui l'invio al display
         oled.clear();
         oled.setFont(System5x7);
         oled.println(String(weekDay) + "  " +String(monthDay) + " " + currentMonthName  + " " + String(currentYear) );
         oled.println();
         oled.setFont(fixed_bold10x15);
         //oled.setFont(TimesNewRoman16_bold);
         //oled.setFont(ZevvPeep8x16);
         //oled.setFont(X11fixed7x14B);
         String timenow = String(currentHour)+":"+twoDigits(currentMinute)+ " " + String(int(t)) + " " + String(int(h)) + "%";
         oled.print(timenow);
         
   
      Blink();
      currentSecond0 = currentSecond ;

      if ((WiFi.status() != WL_CONNECTED) ) {
       Serial.println("Reconnecting to WiFi...");
       WiFi.disconnect();
       WiFi.reconnect();
       }
   }


   
  delay(0);
}
///////////////////////////////////////////////////////////////////////////////////////
void Blink() {
          digitalWrite(LED_BUILTIN, HIGH);
     delay (200);
     digitalWrite(LED_BUILTIN, LOW);
     delay (200);
    }
//////////////////////////////////////////////////////////////////////////////////////
String twoDigits(int digits){
  if(digits < 10) {
    String i = '0'+String(digits);
    return i;
  }
  else {
    return String(digits);
  }
}
