/*
Copyright 2016 German Martin (gmag11@gmail.com). All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are
permitted provided that the following conditions are met :

1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list
of conditions and the following disclaimer in the documentation and / or other materials
provided with the distribution.

THIS SOFTWARE IS PROVIDED BY <COPYRIGHT HOLDER> ''AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.IN NO EVENT SHALL <COPYRIGHT HOLDER> OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
    ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING
        NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

    The views and conclusions contained in the software and documentation are those of the
    authors and should not be interpreted as representing official policies, either expressed
    or implied, of German Martin
*/

/*
 Name:    NtpClient.ino
 Created: 20/08/2016
 Author:  gmag11@gmail.com
 Editor:  http://www.visualmicro.com
*/
//            WEMOS D1 R1

#include <TimeLib.h>
#include "WifiConfig.h"
#include <NtpClientLib.h>    // non fornisce il giorno della settimana
#include <ESP8266WiFi.h>
#include <ESP8266mDNS.h>   
#include "Wire.h"
//////////////////////////////////////// Termometro
#include <Adafruit_Sensor.h>
#include <DHT.h>
#define DHTTYPE    DHT11   
#define DHTPIN 14     // Digital pin connected to the DHT sensor  D5 = GP-IO 14
//#define DHTTYPE    DHT22  
DHT dht(DHTPIN, DHTTYPE); 
// current temperature & humidity, updated in loop()
float t = 0.0;
float h = 0.0;
unsigned long previousMillis = 0;    // will store last time DHT was updated
// Updates DHT readings every 30 seconds
const long interval = 30000;  
unsigned long currentMillis = millis();

////////////////////////////////////////   Display
#include <Wire.h>
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
// 0X3C+SA0 - 0x3C or 0x3D
#define I2C_ADDRESS 0x3C

// Define proper RST_PIN if required.
#define RST_PIN -1

SSD1306AsciiWire oled;
////////////////////////////////////////


#ifndef WIFI_CONFIG_H
#define YOUR_WIFI_SSID "SIP-2"
#define YOUR_WIFI_PASSWD "ambarabaciccicocco"
#endif // !WIFI_CONFIG_H

#define ONBOARDLED 2 // Built in LED on ESP-12/ESP-07
#define SHOW_TIME_PERIOD 200    //  <---------300
#define NTP_TIMEOUT 1500



uint8_t Ore, Minuti, Secondi, i, j;  //   // byte     Scritti sul display
int Hours, Minutes, Seconds, Min, Sec = 0;  


int8_t timeZone = -3;    // -5 Paraguay ...  -1 GMT
int8_t minutesTimeZone = 0;

//const PROGMEM char *ntpServer = "pool.ntp.org";
const PROGMEM char *ntpServer = "192.168.1.250";

bool wifiFirstConnected = false;
#define OptoIs 16 // D2 ....GPIO16 
String TimeDate ="";
String TimeDate0="";

IPAddress local_IP(192, 168, 1, 253);   // Local IP
IPAddress gateway(192, 168, 1, 1);       // gateway of my network
IPAddress subnet(255, 255, 255, 0);       // subnet mask of my network

const char* DeviceName = "ntpclient"; //       ntpclient.local  non funziona con ESP8266 ...solo con ESP32

// bool Semaforo = false;

//Week Days
//String weekDays[7]={"Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"};
String weekDays[7]={"Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"};

//Month names
String months[12]={"Gennaio", "Febbraio", "Mazo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"};

//////////////////////////////////////////////////////////////////////////////////////
String twoDigits(int digits){
  if(digits < 10) {
    String i = '0'+String(digits);
    return i;
  }
  else {
    return String(digits);
  }
}
///////////////////////////////////////////////////////////////////////////////////////
void Blink() {
          digitalWrite(LED_BUILTIN, HIGH);
     delay (200);
     digitalWrite(LED_BUILTIN, LOW);
     delay (200);
    }
//////////////////////////////////////////////////////////////////////////////////////

void DoSerial(){ //  Subroutine to handle characters typed via Serial Monitor Window

  char ch = toupper(Serial.read());  // Read the character and convert to upper case
  Serial.print(ch);                // Echo character to serial monitor to show we got it

  // Use Switch/Case statement to handle the different commands
  switch (ch) {
          case 'H':
//                P1ora();
                break;

          case 'M':
//                P1minuto();
                break;
          case 'S':
//                P1secondo();
                break;
          case 'F':
//                Ferma1();
                break;
  }
  
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
void onSTAConnected (WiFiEventStationModeConnected ipInfo) {
    Serial.printf ("Connected to %s\r\n", ipInfo.ssid.c_str ());
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
// Start NTP only after IP network is connected
void onSTAGotIP (WiFiEventStationModeGotIP ipInfo) {
    Serial.printf ("Got IP: %s\r\n", ipInfo.ip.toString ().c_str ());
    Serial.printf ("Connected: %s\r\n", WiFi.status () == WL_CONNECTED ? "yes" : "no");
    digitalWrite (ONBOARDLED, LOW); // Turn on LED
    wifiFirstConnected = true;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
// Manage network disconnection
void onSTADisconnected (WiFiEventStationModeDisconnected event_info) {
    Serial.printf ("Disconnected from SSID: %s\n", event_info.ssid.c_str ());
    Serial.printf ("Reason: %d\n", event_info.reason);
    digitalWrite (ONBOARDLED, HIGH); // Turn off LED
    //NTP.stop(); // NTP sync can be disabled to avoid sync errors
    WiFi.reconnect ();
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
void processSyncEvent (NTPSyncEvent_t ntpEvent) {
    if (ntpEvent < 0) {
        Serial.printf ("Time Sync error: %d\n", ntpEvent);
        if (ntpEvent == noResponse)
            Serial.println ("NTP server not reachable");
        else if (ntpEvent == invalidAddress)
            Serial.println ("Invalid NTP server address");
        else if (ntpEvent == errorSending)
            Serial.println ("Error sending request");
        else if (ntpEvent == responseError)
            Serial.println ("NTP response error");
    } else {
        if (ntpEvent == timeSyncd) {
            Serial.print ("Got NTP time: "); // <----------------------------------------------------------
            Serial.println (NTP.getTimeDateString (NTP.getLastNTPSync ()));
        }
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////
boolean syncEventTriggered = false; // True if a time even has been triggered
NTPSyncEvent_t ntpEvent; // Last triggered event

//#########################################################################################
void SetupDeviceName(const char *DeviceName) {
  if (MDNS.begin(DeviceName)) { // The name that will identify your device on the network
    Serial.println("mDNS responder started");  // Multicast DNS
    Serial.print("Device name: ");
    Serial.println(DeviceName);
    MDNS.addService("n8i-mlp", "tcp", 23); // Add service
  }
  else {
    Serial.println("Error setting up MDNS responder");
  }
}
//#########################################################################################
////////////////////////////////////////////////////////////////////////////////////////////////////////
void setup () {
  //////////////////////////////////// Display
    Wire.begin(); // wake up I2C bus
    Wire.setClock(400000L);
  #if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
  #else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
  #endif // RST_PIN >= 0
  /////////////////////////////////////
  
     pinMode(LED_BUILTIN, OUTPUT);
      
    static WiFiEventHandler e1, e2, e3;

    Serial.begin (115200);
    Serial.println ();

     dht.begin();  // Inizializza il sensore di temperatura
    
    WiFi.mode (WIFI_STA);

     WiFi.disconnect();
    delay(100);
      WiFi.persistent(false); // Non scritto in EEROM

      WiFi.setAutoConnect(true);    // ??
      WiFi.setAutoReconnect(true);  // ??
  
     // Configures static IP address
     // if (!WiFi.config(local_IP, gateway, subnet, primaryDNS, secondaryDNS)) {
      if (!WiFi.config(local_IP, gateway, subnet)) {
        Serial.println("STA Failed to configure");
      }
    
    WiFi.begin (YOUR_WIFI_SSID, YOUR_WIFI_PASSWD);

    pinMode (ONBOARDLED, OUTPUT); // Onboard LED
    digitalWrite (ONBOARDLED, HIGH); // Switch off LED

    NTP.onNTPSyncEvent ([](NTPSyncEvent_t event) {
        ntpEvent = event;
        syncEventTriggered = true;
    });

    // Deprecated
    /*WiFi.onEvent([](WiFiEvent_t e) {
        Serial.printf("Event wifi -----> %d\n", e);
    });*/
   // Eventi
    e1 = WiFi.onStationModeGotIP (onSTAGotIP);// As soon WiFi is connected, start NTP Client
    e2 = WiFi.onStationModeDisconnected (onSTADisconnected);
    e3 = WiFi.onStationModeConnected (onSTAConnected);

}
////////////////////////////////////////////////////////////////////////////////////////////////////////
void loop () {
    if (Serial.available()) DoSerial();  // Loop looking for something on serial port

  ////////// Legge la Temperatura e l'umidità
  currentMillis = millis();
  if (currentMillis - previousMillis >= interval) {
    // save the last time you updated the DHT values
    previousMillis = currentMillis;
    // Read temperature as Celsius (the default)
    float newT = dht.readTemperature();
    // Read temperature as Fahrenheit (isFahrenheit = true)
    //float newT = dht.readTemperature(true);
    // if temperature read failed, don't change t value
    if (isnan(newT)) {
      Serial.println("Failed to read Temperature from DHT sensor!");
    }
    else {
      t = newT;
      Serial.print(t);
      Serial.println(" ºC");
    }
    // Read Humidity
    float newH = dht.readHumidity();
    // if humidity read failed, don't change h value 
    if (isnan(newH)) {
      Serial.println("Failed to read Humidity from DHT sensor!");
    }
    else {
      h = newH;
      Serial.print(h);
      Serial.println(" %");
    }
  }
  /////////
      
    static int i = 0;
    static int last = 0;

    if (wifiFirstConnected) {
        wifiFirstConnected = false;
        NTP.setInterval (63);
        NTP.setNTPTimeout (NTP_TIMEOUT);
        NTP.begin (ntpServer, timeZone, true, minutesTimeZone);
    }

    if (syncEventTriggered) {
        processSyncEvent (ntpEvent);
        syncEventTriggered = false;
    }

    if ((millis () - last) > SHOW_TIME_PERIOD) {
        //Serial.println(millis() - last);
        last = millis ();
        TimeDate = NTP.getTimeDateString ();
        
//        Serial.println(TimeDate); // 19:29:50 25/02/2021
//        Serial.println(NTP.getDateStr()); // 25/02/2021

        
        if (TimeDate != TimeDate0) {
          TimeDate0 = TimeDate;
         Blink(); // Manda un impulso all'orologio eventuelmente

          Serial.print(TimeDate.substring(0,2)); Serial.print(":");
          Hours = TimeDate.substring(0,2).toInt();
          //Ore = TimeDate.substring(0,1).toInt() * 16  + TimeDate.substring(1,2).toInt() ;
          
          Serial.print(TimeDate.substring(3,5)); Serial.print(":"); 
          Minutes=TimeDate.substring(3,5).toInt();
//          Min = TimeDate.substring(3,4).toInt();
//          if (Min > 2) {j = 1;}
//          else {j = 0;}
//          Minuti = (j + TimeDate.substring(3,4).toInt()) *16 + TimeDate.substring(4,5).toInt();     

          
          Serial.print(TimeDate.substring(6,8)); 
          Serial.print("   ");
          String monthDay = TimeDate.substring(9,11);
          Serial.print(monthDay);  // giorno
          Serial.print("  ");
          // Serial.print(TimeDate.substring(12,14));  // mese
          int mesecorrente = TimeDate.substring(12,14).toInt();
          String currentMonthName = months[mesecorrente-1];
          Serial.print(currentMonthName);
          
          Serial.print("  ");
          String currentYear = TimeDate.substring(15,19);
          Serial.print(currentYear);  // anno
        
          Serial.println();
          
        // qui scrive sul display

         oled.clear();
         oled.setFont(System5x7);
//     oled.println(String(weekDay) + "  " +String(monthDay) + " " + currentMonthName  + " " + String(currentYear) );
         oled.println(monthDay + " " + currentMonthName  + " " + currentYear );
         oled.println();
         oled.setFont(fixed_bold10x15);
         //oled.setFont(TimesNewRoman16_bold);
         //oled.setFont(ZevvPeep8x16);
         //oled.setFont(X11fixed7x14B);
         String timenow = String(Hours)+":"+twoDigits(Minutes)+ " " + String(int(t)) + " " + String(int(h)) + "%";
         oled.print(timenow);


        //  Serial.print(Hours);  Serial.print(Minutes); Serial.println(Seconds);

                     
//                      Serial.print (i); Serial.print (" ");
//                      Serial.print (NTP.getTimeDateString ()); Serial.println (" ");
//                      Serial.print (NTP.isSummerTime () ? "Summer Time. " : "Winter Time. ");
//                      Serial.print ("WiFi is ");
//                      Serial.print (WiFi.isConnected () ? "connected" : "not connected"); Serial.print (". ");
//                      Serial.print ("Uptime: ");
//                      Serial.print (NTP.getUptimeString ()); Serial.print (" since ");
//                      Serial.println (NTP.getTimeDateString (NTP.getFirstSync ()).c_str ());
//                      Serial.printf ("Free heap: %u\n", ESP.getFreeHeap ());
            //  i++;
        }
    }
    delay (0);
}
