#include <stdlib.h>

void main() {
  char* buffer;
  char* buffer_next;
  char* buffer_end;

  // Running cbmc with --object-bits 7 --32
  // Top 7 bits of pointer are object id
  // Bottom 32-7 bits of pointer are object offset
  // Ensure all valid offsets fit within 32-7 bits.

  uint32_t buffer_length;
  __CPROVER_assume(buffer_length < 0x02000000);
  buffer = malloc(buffer_length);

  size_t offset1;
  size_t offset2;
  __CPROVER_assume(offset1 < offset2);
  __CPROVER_assume(offset1 < buffer_length);
  __CPROVER_assume(offset2 < buffer_length);
  buffer_next = buffer + offset1;
  buffer_end = buffer + offset2;

  uint32_t length;
  __CPROVER_assume(length < (buffer_end - buffer_next));

  __CPROVER_size_t show_buffer_object = __CPROVER_POINTER_OBJECT(buffer_next);
  __CPROVER_ssize_t show_buffer_offset = __CPROVER_POINTER_OFFSET(buffer_next);
  __CPROVER_size_t show_buffer_size = __CPROVER_OBJECT_SIZE(buffer_next);
  __CPROVER_assert(__CPROVER_w_ok(buffer_next, length), "buffer length");
}
