<?php

$basePath =  realpath(__DIR__);

require $basePath . '/vendor/autoload.php';

$configPath = \Directus\create_config_path($basePath, NULL);
$app = \Directus\create_app($basePath, require $configPath);

$acl = $app->getContainer()->get('acl');
$acl->setPermissions(['global' => [['role' => 1]]]);
$acl->setUserId(1);
$acl->setUserEmail('admin@example.com');
$acl->setUserFullName('Admin');

$_SERVER['REMOTE_ADDR'] = '127.0.0.1';

\Directus\Database\TableGatewayFactory::setContainer($app->getContainer());
\Directus\Database\TableGateway\BaseTableGateway::setContainer($app->getContainer());
\Directus\Database\TableGateway\BaseTableGateway::setHookEmitter($app->getContainer()->get('hook_emitter'));

$ts = new \Directus\Services\TablesService($app->getContainer());

$idField = [
    'field' => 'id',
    'collection' => 'foo',
    'datatype' => 'INT',
    'unique' => FALSE,
    'primary_key' => TRUE,
    'auto_increment' => TRUE,
    'default_value' => NULL,
    'signed' => FALSE,
    'type' => 'integer',
    'sort' => 0,
    'interface' => 'primary-key',
    'required' => TRUE,
    'readonly' => FALSE,
    'width' => 'full',
    'length' => 10
];

$nameField = [
    'field' => 'name',
    'collection' => 'foo',
    'datatype' => 'VARCHAR',
    'primary_key' => FALSE,
    'type' => 'string',
    'default_value' => '',
    'interface' => 'text-input',
    'required' => TRUE,
    'width' => 'full',
    'length' => 200,
    'options' => [
        'trim' => TRUE,
        'showCharacterCount' => FALSE,
        'formatValue' => TRUE,
        'width' => 'auto'
    ]
];

$ts->createTable('foo55', [
    'managed' => TRUE,
    'fields' => [
        'id' => $idField,
        'naampje' => $nameField
    ]
]);
