/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.OpenAssistSidePanelAction;
import com.intellij.ide.actions.WhatsNewAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import io.flutter.FlutterInitializer;
import io.flutter.assistant.whatsnew.FlutterNewsBundleCreator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OpenFlutterNewsSidePanelAction
extends OpenAssistSidePanelAction {
    @NotNull
    private static final WhatsNewAction action = new WhatsNewAction();
    @NotNull
    private static final Set<Project> openProjectTools = new HashSet<Project>();
    @NotNull
    private final Map<Project, FlutterNewsToolWindowListener> myProjectToListenerMap = new HashMap<Project, FlutterNewsToolWindowListener>();

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabled(false);
        } else if (!presentation.isEnabled()) {
            presentation.setEnabled(true);
        }
        action.update(e);
        presentation.setText("What's New in Flutter");
        presentation.setDescription("See the recent updates to Flutter and the plugin.");
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        this.openWhatsNewSidePanel(Objects.requireNonNull(event.getProject()), false);
    }

    public void openWhatsNewSidePanel(@NotNull Project project, boolean isAutoOpened) {
        FlutterNewsBundleCreator bundleCreator = (FlutterNewsBundleCreator)AssistantBundleCreator.EP_NAME.findExtension(FlutterNewsBundleCreator.class);
        if (bundleCreator == null) {
            return;
        }
        FlutterNewsToolWindowListener.fireOpenEvent(project, isAutoOpened);
        this.openWindow("DeveloperServices.FlutterNewsAssistant", project);
        this.myProjectToListenerMap.computeIfAbsent(project, this::newFlutterNewsToolWindowListener);
    }

    @NotNull
    private FlutterNewsToolWindowListener newFlutterNewsToolWindowListener(@NotNull Project project) {
        FlutterNewsToolWindowListener listener = new FlutterNewsToolWindowListener(project, this.myProjectToListenerMap);
        project.getMessageBus().connect((Disposable)project).subscribe(ToolWindowManagerListener.TOPIC, (Object)listener);
        return listener;
    }

    static class FlutterNewsToolWindowListener
    implements ToolWindowManagerListener {
        @NotNull
        private final Project myProject;
        @NotNull
        Map<Project, FlutterNewsToolWindowListener> myProjectToListenerMap;
        private boolean isOpen;

        private FlutterNewsToolWindowListener(@NotNull Project project, @NotNull Map<Project, FlutterNewsToolWindowListener> projectToListenerMap) {
            this.myProject = project;
            this.myProjectToListenerMap = projectToListenerMap;
            this.isOpen = true;
            project.getMessageBus().connect((Disposable)project).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (!project.equals((Object)myProject)) {
                        return;
                    }
                    if (isOpen) {
                        FlutterNewsToolWindowListener.fireClosedEvent(myProject);
                        isOpen = false;
                    }
                    myProjectToListenerMap.remove(project);
                }
            });
        }

        public void toolWindowRegistered(@NotNull String id) {
        }

        public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
            if (id.equals("Assistant:")) {
                this.myProjectToListenerMap.remove(this.myProject);
            }
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    this.myProjectToListenerMap.remove(this.myProject);
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Assistant:");
                if (window == null) {
                    return;
                }
                if (!"DeveloperServices.FlutterNewsAssistant".equals(window.getHelpId())) {
                    return;
                }
                if (this.isOpen && !window.isVisible()) {
                    FlutterNewsToolWindowListener.fireClosedEvent(this.myProject);
                    this.isOpen = false;
                } else if (!this.isOpen && window.isVisible()) {
                    FlutterNewsToolWindowListener.fireOpenEvent(this.myProject, false);
                    this.isOpen = true;
                }
            });
        }

        private static void fireOpenEvent(@NotNull Project project, boolean isAutoOpened) {
            if (openProjectTools.contains(project)) {
                return;
            }
            FlutterInitializer.getAnalytics().sendEvent("intellij", isAutoOpened ? "AutoOpenFlutterNews" : "OpenFlutterNews");
        }

        private static void fireClosedEvent(@NotNull Project project) {
            openProjectTools.remove(project);
            FlutterInitializer.getAnalytics().sendEvent("intellij", "CloseFlutterNews");
        }
    }
}

