/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ProjectTopics;
import com.intellij.facet.FacetManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.IdeaProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.modules.CircularModuleDependenciesDetector;
import io.flutter.android.AndroidModuleLibraryProperties;
import io.flutter.android.AndroidModuleLibraryType;
import io.flutter.sdk.AbstractLibraryManager;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.FlutterModuleUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleLibraryManager
extends AbstractLibraryManager<AndroidModuleLibraryProperties> {
    private static final Logger LOG = Logger.getInstance(AndroidModuleLibraryManager.class);
    private static final String BUILD_FILE_NAME = "build.gradle";
    private final AtomicBoolean isUpdating = new AtomicBoolean(false);
    private final AtomicBoolean isDisabled = new AtomicBoolean(false);

    public AndroidModuleLibraryManager(@NotNull Project project) {
        super(project);
    }

    public void update() {
        this.doGradleSync(this.getProject(), this::scheduleAddAndroidLibraryDeps);
    }

    private Void scheduleAddAndroidLibraryDeps(@NotNull Project androidProject) {
        ApplicationManager.getApplication().invokeLater(() -> this.addAndroidLibraryDependencies(androidProject), ModalityState.NON_MODAL);
        return null;
    }

    private void addAndroidLibraryDependencies(@NotNull Project androidProject) {
        for (Module flutterModule : FlutterModuleUtils.getModules((Project)this.getProject())) {
            if (!FlutterModuleUtils.isFlutterModule((Module)flutterModule)) continue;
            for (Module module : ModuleManager.getInstance((Project)androidProject).getModules()) {
                this.addAndroidLibraryDependencies(androidProject, module, flutterModule);
            }
        }
        this.isUpdating.set(false);
    }

    private void addAndroidLibraryDependencies(@NotNull Project androidProject, @NotNull Module androidModule, @NotNull Module flutterModule) {
        Sdk currentSdk = ModuleRootManager.getInstance((Module)androidModule).getSdk();
        if (currentSdk != null) {
            // empty if block
        }
        LibraryTable androidProjectLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(androidProject);
        Library[] androidProjectLibraries = androidProjectLibraryTable.getLibraries();
        LibraryTable flutterProjectLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.getProject());
        Library[] flutterProjectLibraries = flutterProjectLibraryTable.getLibraries();
        HashSet<String> knownLibraryNames = new HashSet<String>(flutterProjectLibraries.length);
        for (Library lib : flutterProjectLibraries) {
            if (lib.getName() == null) continue;
            knownLibraryNames.add(lib.getName());
        }
        for (Library library : androidProjectLibraries) {
            List<String> roots;
            Set filteredRoots;
            if (library.getName() == null || knownLibraryNames.contains(library.getName()) || (filteredRoots = (roots = Arrays.asList(library.getRootProvider().getUrls(OrderRootType.CLASSES))).stream().filter(s -> AndroidModuleLibraryManager.shouldIncludeRoot(s)).collect(Collectors.toSet())).isEmpty()) continue;
            HashSet<String> sources = new HashSet<String>(Arrays.asList(library.getRootProvider().getUrls(OrderRootType.SOURCES)));
            this.updateLibraryContent(library.getName(), filteredRoots, sources);
            this.updateAndroidModuleLibraryDependencies(flutterModule);
        }
    }

    protected void updateModuleLibraryDependencies(@NotNull Library library) {
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (!FlutterModuleUtils.declaresFlutter((Module)module)) {
                AndroidModuleLibraryManager.addFlutterLibraryDependency((Module)module, (Library)library);
                continue;
            }
            AndroidModuleLibraryManager.removeFlutterLibraryDependency((Module)module, (Library)library);
        }
    }

    private void updateAndroidModuleLibraryDependencies(Module flutterModule) {
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            JavaProjectModelModifier[] modifiers;
            ModuleRootManager rootManager;
            Couple circularModules;
            if (module == flutterModule || null == FacetManager.getInstance((Module)module).findFacet(AndroidFacet.ID, "Android") || (circularModules = CircularModuleDependenciesDetector.addingDependencyFormsCircularity((Module)module, (Module)flutterModule)) != null || (rootManager = ModuleRootManager.getInstance((Module)module)).isDependsOn(flutterModule)) continue;
            for (JavaProjectModelModifier modifier : modifiers = (JavaProjectModelModifier[])JavaProjectModelModifier.EP_NAME.getExtensions((AreaInstance)this.getProject())) {
                if (!(modifier instanceof IdeaProjectModelModifier)) continue;
                modifier.addModuleDependency(module, flutterModule, DependencyScope.COMPILE, false);
            }
        }
    }

    @NotNull
    protected String getLibraryName() {
        return "Android Libraries";
    }

    @NotNull
    protected PersistentLibraryKind<AndroidModuleLibraryProperties> getLibraryKind() {
        return AndroidModuleLibraryType.LIBRARY_KIND;
    }

    private void scheduleUpdate() {
        if (this.isUpdating.get() || this.isDisabled.get()) {
            return;
        }
        Runnable runnable = this::updateAndroidLibraries;
        DumbService.getInstance((Project)this.getProject()).smartInvokeLater(runnable, ModalityState.NON_MODAL);
    }

    private void updateAndroidLibraries() {
        if (!this.isUpdating.compareAndSet(false, true)) {
            return;
        }
        this.update();
    }

    private void doGradleSync(Project flutterProject, final Function<Project, Void> callback) {
        VirtualFile dir = flutterProject.getBaseDir().findChild("android");
        if (dir == null) {
            dir = flutterProject.getBaseDir().findChild(".android");
        }
        if (dir == null) {
            return;
        }
        final EmbeddedAndroidProject androidProject = new EmbeddedAndroidProject(Paths.get(FileUtilRt.toSystemIndependentName((String)dir.getPath()), new String[0]));
        androidProject.init42(null);
        Disposer.register((Disposable)flutterProject, (Disposable)androidProject);
        GradleSyncListener listener = new GradleSyncListener(){

            public void syncTaskCreated(@NotNull Project project, @NotNull GradleSyncInvoker.Request request) {
            }

            public void syncStarted(@NotNull Project project, boolean skipped, boolean sourceGenerationRequested) {
            }

            public void setupStarted(@NotNull Project project) {
            }

            public void syncSucceeded(@NotNull Project project) {
                if (AndroidModuleLibraryManager.this.isUpdating.get()) {
                    callback.apply(androidProject);
                }
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                AndroidModuleLibraryManager.this.isUpdating.set(false);
            }

            public void syncSkipped(@NotNull Project project) {
                AndroidModuleLibraryManager.this.isUpdating.set(false);
            }
        };
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        GradleSyncInvoker gradleSyncInvoker = (GradleSyncInvoker)ApplicationManager.getApplication().getService(GradleSyncInvoker.class);
        gradleSyncInvoker.requestProjectSync((Project)androidProject, request, listener);
    }

    private static boolean shouldIncludeRoot(String path) {
        return !path.endsWith("res") && !path.contains("flutter.jar") && !path.contains("flutter-x86.jar");
    }

    @NotNull
    public static AndroidModuleLibraryManager getInstance(@NotNull Project project) {
        return (AndroidModuleLibraryManager)((Object)ServiceManager.getService((Project)project, AndroidModuleLibraryManager.class));
    }

    public static void startWatching(final @NotNull Project project) {
        if (project.isDefault()) {
            return;
        }
        if (AndroidModuleLibraryManager.hasAndroidDir(project)) {
            final AndroidModuleLibraryManager manager = AndroidModuleLibraryManager.getInstance(project);
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileContentsChangedAdapter(){

                protected void onFileChange(@NotNull VirtualFile file) {
                    AndroidModuleLibraryManager.fileChanged(project, file);
                }

                protected void onBeforeFileChange(@NotNull VirtualFile file) {
                }
            }, (Disposable)project);
            project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    manager.scheduleUpdate();
                }
            });
            manager.scheduleUpdate();
        }
    }

    private static boolean hasAndroidDir(Project project) {
        if (FlutterSdkUtil.hasFlutterModules((Project)project)) {
            VirtualFile base = project.getBaseDir();
            VirtualFile dir = base.findChild("android");
            if (dir == null) {
                dir = base.findChild(".android");
            }
            return dir != null;
        }
        return false;
    }

    private static void fileChanged(@NotNull Project project, @NotNull VirtualFile file) {
        if (!BUILD_FILE_NAME.equals(file.getName())) {
            return;
        }
        if (LocalFileSystem.getInstance() != file.getFileSystem() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)file, (boolean)true)) {
            return;
        }
        AndroidModuleLibraryManager.getInstance(project).scheduleUpdate();
    }

    private class EmbeddedAndroidProject
    extends ProjectImpl {
        private Path path;
        static final String TEMPLATE_PROJECT_NAME = "_android";

        protected EmbeddedAndroidProject(Path filePath) {
            super(filePath, TEMPLATE_PROJECT_NAME);
            this.path = filePath;
        }

        public String getLocationHash() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init42(@Nullable ProgressIndicator indicator) {
            boolean finished = false;
            try {
                Method method = ReflectionUtil.getDeclaredMethod(ProjectManagerImpl.class, (String)"initProject", (Class[])new Class[]{Path.class, ProjectImpl.class, Boolean.TYPE, Boolean.TYPE, Project.class, ProgressIndicator.class});
                if (method == null) {
                    this.disableGradleSyncAndNotifyUser();
                    return;
                }
                try {
                    method.invoke(null, new Object[]{this.path, this, true, true, null, null});
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.disableGradleSyncAndNotifyUser();
                    if (!finished) {
                        TransactionGuard.submitTransaction((Disposable)this, () -> WriteAction.run(() -> {
                            if (this.isDisposed() && !AndroidModuleLibraryManager.this.isDisabled.get()) {
                                Disposer.dispose((Disposable)this);
                            }
                        }));
                    }
                    return;
                }
                finished = true;
            }
            finally {
                if (!finished) {
                    TransactionGuard.submitTransaction((Disposable)this, () -> WriteAction.run(() -> {
                        if (this.isDisposed() && !AndroidModuleLibraryManager.this.isDisabled.get()) {
                            Disposer.dispose((Disposable)this);
                        }
                    }));
                }
            }
        }

        private void disableGradleSyncAndNotifyUser() {
            FlutterSettings instance = FlutterSettings.getInstance();
            instance.setSyncingAndroidLibraries(false);
            AndroidModuleLibraryManager.this.isDisabled.set(true);
            Notification notification = new Notification(GradleUtil.GRADLE_SYSTEM_ID.getReadableName() + " sync", "Gradle sync disabled", "An internal error prevents Gradle from analyzing the Android module at " + String.valueOf(this.path), NotificationType.WARNING, null);
            Notifications.Bus.notify((Notification)notification, (Project)this);
        }
    }
}

