/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.assistant.whatsnew;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import io.flutter.assistant.whatsnew.FlutterNewsBundle;
import io.flutter.sdk.FlutterSdk;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterNewsBundleCreator
implements AssistantBundleCreator {
    public static final String BUNDLE_ID = "DeveloperServices.FlutterNewsAssistant";
    public static final String FLUTTER_NEWS_PATH = "/flutter-news-assistant.xml";
    private String pluginVersion;
    private String flutterVersion;

    @NotNull
    public String getBundleId() {
        return BUNDLE_ID;
    }

    @Nullable
    public URL getConfig() {
        return null;
    }

    @Nullable
    public FlutterNewsBundle getBundle(@NotNull Project project) {
        assert (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        @Nullable FlutterSdk sdk = FlutterSdk.getFlutterSdk((Project)project);
        if (sdk == null) {
            FlutterNewsBundleCreator.getLog().error("Could not get Flutter SDK");
            return null;
        }
        this.flutterVersion = sdk.getVersion().fullVersion();
        PluginManager pluginManager = PluginManager.getInstance();
        IdeaPluginDescriptor descriptor = pluginManager.findEnabledPlugin(PluginId.getId((String)"io.flutter"));
        if (descriptor == null) {
            FlutterNewsBundleCreator.getLog().error("Could not get plugin version");
            return null;
        }
        this.pluginVersion = descriptor.getVersion();
        FlutterNewsBundle bundle = this.parseBundle(FLUTTER_NEWS_PATH);
        if (bundle == null) {
            bundle = this.parseBundle(FLUTTER_NEWS_PATH.substring(0, FLUTTER_NEWS_PATH.length() - 3) + this.pluginVersion + ".xml");
        }
        if (bundle == null) {
            bundle = this.parseBundle(FLUTTER_NEWS_PATH.substring(0, FLUTTER_NEWS_PATH.length() - 3) + this.flutterVersion + ".xml");
        }
        if (bundle == null) {
            FlutterNewsBundleCreator.getLog().error("Could not parse bundle");
        }
        return bundle;
    }

    @NotNull
    public AnalyticsProvider getAnalyticsProvider() {
        return AnalyticsProvider.getNoOp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FlutterNewsBundle parseBundle(String path) {
        try (InputStream configStream = this.getClass().getResourceAsStream(path);){
            if (configStream == null) {
                FlutterNewsBundle flutterNewsBundle2 = null;
                return flutterNewsBundle2;
            }
            FlutterNewsBundle flutterNewsBundle = (FlutterNewsBundle)DefaultTutorialBundle.parse((InputStream)configStream, FlutterNewsBundle.class, (String)this.getBundleId());
            return flutterNewsBundle;
        }
        catch (Exception e) {
            FlutterNewsBundleCreator.getLog().warn("Error parsing bundle", (Throwable)e);
            return null;
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(FlutterNewsBundleCreator.class);
    }
}

