/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import io.flutter.editor.ColorPickerProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Unit;

public class AndroidStudioColorPickerProvider
implements ColorPickerProvider {
    private Balloon popup;

    public void show(Color initialColor, JComponent component, Point offset, Balloon.Position position, ColorPickerProvider.ColorListener colorListener, final Runnable onCancel, final Runnable onOk) {
        if (this.popup != null) {
            this.popup.dispose();
        }
        this.popup = null;
        JComponent colorPanel = new ColorPickerBuilder().setOriginalColor(initialColor != null ? initialColor : new Color(255, 255, 255)).addSaturationBrightnessComponent().addColorAdjustPanel().addColorValuePanel().withFocus().addOperationPanel(okColor -> {
            onOk.run();
            return Unit.INSTANCE;
        }, cancelColor -> {
            onCancel.run();
            return Unit.INSTANCE;
        }).withFocus().setFocusCycleRoot(true).focusWhenDisplay(true).addKeyAction(KeyStroke.getKeyStroke(27, 0), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                onCancel.run();
            }
        }).addKeyAction(KeyStroke.getKeyStroke(10, 0), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                onOk.run();
            }
        }).addColorPickerListener((c, o) -> colorListener.colorChanged(c, null)).build();
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder(colorPanel);
        balloonBuilder.setFadeoutTime(0L);
        balloonBuilder.setAnimationCycle(0);
        balloonBuilder.setHideOnClickOutside(true);
        balloonBuilder.setHideOnKeyOutside(false);
        balloonBuilder.setHideOnAction(false);
        balloonBuilder.setCloseButtonEnabled(false);
        balloonBuilder.setBlockClicksThroughBalloon(true);
        balloonBuilder.setRequestFocus(true);
        balloonBuilder.setShadow(true);
        balloonBuilder.setFillColor(colorPanel.getBackground());
        this.popup = balloonBuilder.createBalloon();
        this.popup.show(new RelativePoint((Component)component, offset), position);
    }

    public void dispose() {
        if (this.popup != null) {
            this.popup.dispose();
        }
        this.popup = null;
    }
}

