/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.EditorNotifications;
import io.flutter.FlutterUtils;
import io.flutter.project.FlutterProjectOpenProcessor;
import io.flutter.pub.PubRoot;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterStudioProjectOpenProcessor
extends FlutterProjectOpenProcessor {
    public String getName() {
        return "Flutter Studio";
    }

    public boolean canOpenProject(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        PubRoot root = PubRoot.forDirectory((VirtualFile)file);
        return root != null && root.declaresFlutter();
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor importProvider = this.getDelegateImportProvider(virtualFile);
        if (importProvider == null) {
            return null;
        }
        importProvider.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
        Project project = FlutterUtils.findProject((String)virtualFile.getPath());
        if (project == null || project.isDisposed()) {
            return project;
        }
        for (Module module : FlutterModuleUtils.getModules((Project)project)) {
            if (!FlutterModuleUtils.declaresFlutter((Module)module) || FlutterModuleUtils.isFlutterModule((Module)module)) continue;
            FlutterModuleUtils.setFlutterModuleType((Module)module);
            FlutterModuleUtils.enableDartSDK((Module)module);
        }
        project.save();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        return project;
    }
}

