/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import io.flutter.FlutterBundle;
import io.flutter.module.FlutterModuleBuilder;
import io.flutter.module.FlutterProjectType;
import org.jetbrains.annotations.NotNull;

public abstract class FlutterModuleGroup
extends FlutterModuleBuilder {
    public abstract FlutterProjectType getFlutterProjectType();

    public abstract String getDescription();

    public String getBuilderId() {
        return super.getBuilderId() + this.getFlutterProjectType().arg;
    }

    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        FlutterModuleBuilder.FlutterModuleWizardStep step = (FlutterModuleBuilder.FlutterModuleWizardStep)super.getCustomOptionsStep(context, parentDisposable);
        assert (step != null);
        this.getSettingsField().linkHelpForm(step.getHelpForm());
        this.setProjectTypeInSettings();
        return step;
    }

    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        ModuleWizardStep wizard = super.modifySettingsStep(settingsStep);
        this.setProjectTypeInSettings();
        return wizard;
    }

    public String getParentGroup() {
        return "Flutter";
    }

    protected void setProjectTypeInSettings() {
        this.getSettingsField().updateProjectType(this.getFlutterProjectType());
    }

    public static class Package
    extends FlutterModuleGroup {
        @Override
        @NotNull
        public FlutterProjectType getFlutterProjectType() {
            return FlutterProjectType.PACKAGE;
        }

        public String getPresentableName() {
            return FlutterBundle.message((String)"module.wizard.package_title", (Object[])new Object[0]);
        }

        @Override
        public String getDescription() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.package", (Object[])new Object[0]);
        }

        public int getWeight() {
            return 1;
        }
    }

    public static class Plugin
    extends FlutterModuleGroup {
        @Override
        @NotNull
        public FlutterProjectType getFlutterProjectType() {
            return FlutterProjectType.PLUGIN;
        }

        public String getPresentableName() {
            return FlutterBundle.message((String)"module.wizard.plugin_title", (Object[])new Object[0]);
        }

        @Override
        public String getDescription() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.plugin", (Object[])new Object[0]);
        }

        public int getWeight() {
            return 2;
        }
    }

    public static class Mod
    extends FlutterModuleGroup {
        @Override
        @NotNull
        public FlutterProjectType getFlutterProjectType() {
            return FlutterProjectType.MODULE;
        }

        public String getPresentableName() {
            return FlutterBundle.message((String)"module.wizard.module_title", (Object[])new Object[0]);
        }

        @Override
        public String getDescription() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.module", (Object[])new Object[0]);
        }

        public int getWeight() {
            return 3;
        }
    }

    public static class App
    extends FlutterModuleGroup {
        @Override
        @NotNull
        public FlutterProjectType getFlutterProjectType() {
            return FlutterProjectType.APP;
        }

        public String getPresentableName() {
            return FlutterBundle.message((String)"module.wizard.app_title_short", (Object[])new Object[0]);
        }

        @Override
        public String getDescription() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.app", (Object[])new Object[0]);
        }

        public int getWeight() {
            return 4;
        }
    }
}

