/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.intellij.ProjectTopics;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import io.flutter.FlutterUtils;
import io.flutter.actions.AttachDebuggerAction;
import io.flutter.pub.PubRoot;
import io.flutter.run.SdkAttachConfig;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.GradleUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddToAppUtils {
    private AddToAppUtils() {
    }

    public static boolean initializeAndDetectFlutter(final @NotNull Project project) {
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        Topic topic = AddToAppUtils.getStaticFieldValue(GradleSyncState.class, Topic.class, "GRADLE_SYNC_TOPIC");
        if (topic != null) {
            connection.subscribe(topic, (Object)AddToAppUtils.makeSyncListener(project));
        }
        if (!FlutterModuleUtils.hasFlutterModule((Project)project)) {
            connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                public void moduleAdded(@NotNull Project proj, @NotNull Module mod) {
                    if ("flutter".equals(mod.getName()) || FlutterUtils.flutterGradleModuleName((Project)project).equals(mod.getName())) {
                        AppExecutorUtil.getAppExecutorService().execute(() -> GradleUtils.enableCoeditIfAddToAppDetected(project));
                    }
                }
            });
            return false;
        }
        @Nullable ProjectType projectType = ProjectTypeService.getProjectType((Project)project);
        if (projectType != null && "Android".equals(projectType.getId())) {
            connection.subscribe(DebuggerManagerListener.TOPIC, (Object)AddToAppUtils.makeAddToAppAttachListener(project));
        }
        return true;
    }

    public static <T> T getStaticFieldValue(@NotNull Class objectClass, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        try {
            Field field = ReflectionUtil.findAssignableField((Class)objectClass, fieldType, (String)fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + String.valueOf(objectClass) + "." + fieldName + " is not static");
            }
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    @NotNull
    private static GradleSyncListener makeSyncListener(@NotNull Project project) {
        return new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                GradleUtils.checkDartSupport(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                GradleUtils.checkDartSupport(project);
            }

            public void syncSkipped(@NotNull Project project) {
                GradleUtils.checkDartSupport(project);
            }

            public void sourceGenerationFinished(@NotNull Project project) {
            }
        };
    }

    @NotNull
    private static DebuggerManagerListener makeAddToAppAttachListener(final @NotNull Project project) {
        return new DebuggerManagerListener(){
            DebugProcessListener dpl = new DebugProcessListener(){

                public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                    ThreeState state = (ThreeState)project.getUserData(AttachDebuggerAction.ATTACH_IS_ACTIVE);
                    if (state != null) {
                        project.putUserData(AttachDebuggerAction.ATTACH_IS_ACTIVE, null);
                    }
                }

                public void processAttached(@NotNull DebugProcess process) {
                    if (project.getUserData(AttachDebuggerAction.ATTACH_IS_ACTIVE) != null) {
                        return;
                    }
                    @Nullable RunConfiguration runConfig = AttachDebuggerAction.findRunConfig((Project)project);
                    if (runConfig == null) {
                        return;
                    }
                    if (!(runConfig instanceof SdkAttachConfig)) {
                        return;
                    }
                    FlutterSdk sdk = FlutterSdk.getFlutterSdk((Project)project);
                    if (sdk == null) {
                        return;
                    }
                    DataContext context = DataContext.EMPTY_CONTEXT;
                    PubRoot pubRoot = ((SdkAttachConfig)runConfig).pubRoot;
                    Application app = ApplicationManager.getApplication();
                    project.putUserData(AttachDebuggerAction.ATTACH_IS_ACTIVE, (Object)ThreeState.fromBoolean((boolean)true));
                    app.invokeLater(() -> app.executeOnPooledThread(() -> app.runReadAction(() -> new AttachDebuggerAction().startCommand(project, sdk, pubRoot, context))));
                }
            };

            public void sessionCreated(DebuggerSession session) {
                session.getProcess().addDebugProcessListener(this.dpl);
            }

            public void sessionRemoved(DebuggerSession session) {
                session.getProcess().removeDebugProcessListener(this.dpl);
            }
        };
    }
}

