/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.WeakList;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import io.flutter.FlutterUtils;
import io.flutter.android.GradleSyncProvider;
import io.flutter.utils.AndroidLocationProvider;
import io.flutter.utils.EnableDartSupportForModule;
import io.flutter.utils.FlutterModuleUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleUtils {
    private static final String FLUTTER_PROJECT_NAME = ":flutter:";
    private static final String FLUTTER_TASK_PREFIX = "compileFlutterBuild";
    private static final WeakList<Project> COEDIT_TRANSFORMED_PROJECTS = new WeakList();
    private static final int GRADLE_SYNC_TIMEOUT = 300000;

    public static void addGradleListeners(@NotNull Project project) {
        if (!FlutterUtils.isAndroidStudio()) {
            // empty if block
        }
    }

    public static void scheduleGradleSync(@NotNull Project project) {
        GradleSyncProvider provider = (GradleSyncProvider)GradleSyncProvider.EP_NAME.getExtensionList().get(0);
        provider.scheduleSync(project);
    }

    public static void enableCoeditIfAddToAppDetected(@NotNull Project project) {
        if (GradleUtils.isCoeditTransformedProject(project)) {
            return;
        }
        Map<ProjectData, MultiMap<String, String>> tasks = GradleUtils.getTasksMap(project);
        @NotNull String projectName = project.getName();
        for (ProjectData projectData : tasks.keySet()) {
            MultiMap<String, String> map = tasks.get(projectData);
            Collection col = map.get((Object)FLUTTER_PROJECT_NAME);
            if (col.isEmpty()) {
                col = map.get((Object)"");
            }
            if (col.isEmpty() || !col.parallelStream().anyMatch(x -> x.startsWith(FLUTTER_TASK_PREFIX))) continue;
            ApplicationManager.getApplication().invokeLater(() -> GradleUtils.enableCoEditing(project));
        }
    }

    private static void runAfterSyncFinishes(final @NotNull Project project, @NotNull Consumer<Project> runnable) {
        new WaitFor(300000, () -> runnable.accept(project)){

            public boolean condition() {
                return !GradleSyncState.getInstance((Project)project).isSyncInProgress();
            }
        };
    }

    public static void checkDartSupport(@NotNull Project project) {
        GradleUtils.runAfterSyncFinishes(project, p -> AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            Stream<Module> modules = Arrays.stream(FlutterModuleUtils.getModules((Project)p)).filter(FlutterModuleUtils::declaresFlutter);
            modules.forEach(module -> {
                if (!DartSdkLibUtil.isDartSdkEnabled((Module)module)) {
                    new EnableDartSupportForModule(module).run();
                }
            });
        }, 1L, TimeUnit.SECONDS));
    }

    private static boolean isVanillaAddToApp(@NotNull Project project, @Nullable VirtualFile file, @NotNull String name) {
        if (file == null) {
            return false;
        }
        VirtualFile dir = file.getParent();
        if (dir.findChild(".ios") == null) {
            dir = dir.getParent();
        }
        if (dir.getName().equals(".android")) {
            dir = dir.getParent();
        }
        if (dir.findChild(".ios") == null && dir.findChild("ios") == null) {
            return false;
        }
        if (GradleUtils.doesBuildFileExist(dir)) {
            return true;
        }
        GradleSettingsFile parsedSettings = GradleUtils.parseSettings(project);
        if (parsedSettings == null) {
            return false;
        }
        return GradleUtils.findInclude(Objects.requireNonNull(parsedSettings), name) == null;
    }

    private static boolean doesBuildFileExist(VirtualFile dir) {
        return new File(dir.getPath(), "build.gradle").exists();
    }

    @Nullable
    private static GradleSettingsFile parseSettings(Project project) {
        Project param;
        boolean isAndroidStudio = FlutterUtils.isAndroidStudio();
        VirtualFile projectDir = Objects.requireNonNull(FlutterUtils.getProjectRoot((Project)project));
        Object object = param = isAndroidStudio ? projectDir.findChild("settings.gradle") : project;
        if (param == null) {
            return null;
        }
        Method method = ReflectionUtil.getMethod(BuildModelContext.class, (String)"getOrCreateSettingsFile", (Class[])new Class[]{isAndroidStudio ? VirtualFile.class : Project.class});
        if (method == null) {
            return null;
        }
        try {
            return (GradleSettingsFile)method.invoke((Object)GradleUtils.makeBuildModelContext(project), param);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static BuildModelContext makeBuildModelContext(Project project) {
        Method method = ReflectionUtil.getDeclaredMethod(BuildModelContext.class, (String)"create", (Class[])new Class[]{Project.class});
        if (method != null) {
            try {
                return (BuildModelContext)method.invoke(null, project);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> locationProviderClass = AndroidLocationProvider.class.getInterfaces()[0];
        method = ReflectionUtil.getDeclaredMethod(BuildModelContext.class, (String)"create", (Class[])new Class[]{Project.class, locationProviderClass});
        assert (method != null);
        try {
            return (BuildModelContext)method.invoke(null, project, new AndroidLocationProvider());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void enableCoEditing(@NotNull Project project) {
        VirtualFile flutterModuleDir;
        String flutterModuleName;
        Module module = FlutterUtils.findFlutterGradleModule((Project)project);
        if (module == null) {
            return;
        }
        VirtualFile root = FlutterUtils.locateModuleRoot((Module)module);
        if (root == null) {
            return;
        }
        VirtualFile androidDir = root.getParent();
        if (!GradleUtils.isVanillaAddToApp(project, androidDir, flutterModuleName = (flutterModuleDir = androidDir.getParent()).getName())) {
            return;
        }
        new CoEditHelper(project, flutterModuleDir).enable();
    }

    private static void addCoeditTransformedProject(@NotNull Project project) {
        if (!project.isDisposed()) {
            COEDIT_TRANSFORMED_PROJECTS.add((Object)project);
        }
    }

    private static boolean isCoeditTransformedProject(@NotNull Project project) {
        if (project.isDisposed()) {
            return true;
        }
        for (Project p : COEDIT_TRANSFORMED_PROJECTS) {
            if (!project.equals((Object)p) || p.isDisposed()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Map<ProjectData, MultiMap<String, String>> getTasksMap(Project project) {
        LinkedHashMap<ProjectData, MultiMap<String, String>> tasks = new LinkedHashMap<ProjectData, MultiMap<String, String>>();
        for (GradleProjectSettings setting : GradleSettings.getInstance((Project)project).getLinkedProjectsSettings()) {
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            MultiMap projectTasks = MultiMap.createOrderedSet();
            for (DataNode moduleDataNode : ExternalSystemApiUtil.getChildren((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE)) {
                int colonIndex;
                String moduleId = ((ModuleData)moduleDataNode.getData()).getId();
                String gradlePath = moduleId.charAt(0) != ':' ? ((colonIndex = moduleId.indexOf(58)) > 0 ? moduleId.substring(colonIndex) : ":") : moduleId;
                for (DataNode node : ExternalSystemApiUtil.getChildren((DataNode)moduleDataNode, (Key)ProjectKeys.TASK)) {
                    TaskData taskData = (TaskData)node.getData();
                    String taskName = taskData.getName();
                    if (!StringUtil.isNotEmpty((String)taskName)) continue;
                    String taskPathPrefix = ":".equals(gradlePath) || taskName.startsWith(gradlePath) ? "" : gradlePath + ":";
                    projectTasks.putValue((Object)taskPathPrefix, (Object)taskName);
                }
            }
            tasks.put((ProjectData)projectData.getExternalProjectStructure().getData(), (MultiMap<String, String>)projectTasks);
        }
        return tasks;
    }

    @Nullable
    private static PsiElement findInclude(GradleSettingsFile parsedSettings, String name) {
        Map elements = parsedSettings.getPropertyElements();
        GradleDslElement includes = (GradleDslElement)elements.get("include");
        if (includes == null) {
            return null;
        }
        for (GradleDslElement include : includes.getChildren()) {
            PsiElement expr;
            if (include instanceof GradleDslExpressionList) {
                for (GradleDslExpression expr2 : ((GradleDslExpressionList)include).getExpressions()) {
                    PsiElement lit;
                    if (!(expr2 instanceof GradleDslLiteral) || !GradleUtils.matchesName(lit = expr2.getExpression(), name)) continue;
                    return lit;
                }
            }
            if (!(include instanceof GradleDslLiteral) || !GradleUtils.matchesName(expr = ((GradleDslLiteral)include).getExpression(), name)) continue;
            return expr;
        }
        return null;
    }

    private static boolean matchesName(PsiElement expr, String name) {
        if (expr == null) {
            return false;
        }
        String text = expr.getText();
        return name.equals(text.substring(2, text.length() - 1));
    }

    private static class CoEditHelper {
        @NotNull
        private final Project project;
        @NotNull
        private VirtualFile flutterModuleDir;
        @NotNull
        private final File flutterModuleRoot;
        @NotNull
        private final String flutterModuleName;
        private boolean hasIncludeFlutterModuleStatement;
        private boolean buildFileIsValid;
        private boolean inSameDir;
        private VirtualFile buildFile;
        private VirtualFile settingsFile;
        private VirtualFile projectRoot;
        private String pathToModule;
        private AtomicBoolean errorDuringOperation = new AtomicBoolean(false);

        private CoEditHelper(@NotNull Project project, @NotNull VirtualFile flutterModuleDir) {
            this.project = project;
            this.flutterModuleDir = flutterModuleDir;
            this.flutterModuleRoot = new File(flutterModuleDir.getPath());
            this.flutterModuleName = flutterModuleDir.getName();
        }

        private void enable() {
            if (this.verifyEligibility()) {
                this.makeBuildFile();
                if (this.errorDuringOperation.get()) {
                    return;
                }
                this.addIncludeStatement();
                if (this.errorDuringOperation.get()) {
                    return;
                }
                GradleUtils.addCoeditTransformedProject(this.project);
                this.projectRoot.refresh(false, true);
                if (!this.projectRoot.equals(this.flutterModuleDir.getParent())) {
                    this.flutterModuleDir.refresh(false, true);
                }
                AppExecutorUtil.getAppExecutorService().execute(() -> CoEditHelper.scheduleGradleSyncAfterSyncFinishes(this.project));
            }
        }

        private static void scheduleGradleSyncAfterSyncFinishes(@NotNull Project project) {
            GradleUtils.runAfterSyncFinishes(project, p -> GradleUtils.scheduleGradleSync(project));
        }

        private boolean verifyEligibility() {
            this.projectRoot = FlutterUtils.getProjectRoot((Project)this.project);
            Objects.requireNonNull(this.projectRoot);
            this.settingsFile = this.projectRoot.findChild("settings.gradle");
            if (this.settingsFile == null) {
                return false;
            }
            GradleSettingsFile parsedSettings = GradleUtils.parseSettings(this.project);
            if (parsedSettings == null) {
                return false;
            }
            PsiElement includeFlutterModuleStmt = GradleUtils.findInclude(parsedSettings, this.flutterModuleName);
            this.hasIncludeFlutterModuleStatement = includeFlutterModuleStmt != null;
            this.buildFile = GradleUtil.getGradleBuildFile((File)this.flutterModuleRoot);
            this.buildFileIsValid = this.buildFile != null && GradleUtils.doesBuildFileExist(this.flutterModuleDir) && this.buildFile.getLength() > 0L;
            return !this.hasIncludeFlutterModuleStatement || !this.buildFileIsValid;
        }

        private void makeBuildFile() {
            if (this.buildFileIsValid) {
                return;
            }
            this.createBuildFile();
            if (this.errorDuringOperation.get()) {
                return;
            }
            this.writeBuildFile();
        }

        private void createBuildFile() {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    this.buildFile = this.flutterModuleDir.findOrCreateChildData((Object)this, "build.gradle");
                }
                catch (IOException e) {
                    this.cleanupAfterError();
                }
            });
        }

        private void writeBuildFile() {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try (BufferedOutputStream out = new BufferedOutputStream(this.buildFile.getOutputStream((Object)this));){
                    ((OutputStream)out).write("buildscript {}".getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException ex) {
                    this.cleanupAfterError();
                }
            });
        }

        private void addIncludeStatement() {
            if (this.hasIncludeFlutterModuleStatement) {
                return;
            }
            String originalContent = this.readSettingsFile();
            if (this.errorDuringOperation.get()) {
                return;
            }
            String newContent = this.addStatements(originalContent);
            this.writeSettingsFile(newContent, originalContent);
        }

        private String readSettingsFile() {
            this.inSameDir = this.flutterModuleDir.getParent().equals(this.projectRoot);
            this.pathToModule = FileUtilRt.getRelativePath((File)new File(this.projectRoot.getPath()), (File)this.flutterModuleRoot);
            try {
                Objects.requireNonNull(this.pathToModule);
                Objects.requireNonNull(this.settingsFile);
                BufferedInputStream str = new BufferedInputStream(this.settingsFile.getInputStream());
                return FileUtil.loadTextAndClose((Reader)new InputStreamReader((InputStream)str, CharsetToolkit.UTF8_CHARSET));
            }
            catch (IOException | NullPointerException e) {
                this.cleanupAfterError();
                return "";
            }
        }

        public String addStatements(String originalContent) {
            StringBuilder content = new StringBuilder();
            content.append(originalContent);
            content.append('\n');
            content.append("include ':");
            content.append(this.flutterModuleName);
            content.append("'\n");
            if (!this.inSameDir) {
                content.append("project(':");
                content.append(this.flutterModuleName);
                content.append("').projectDir = new File('");
                content.append(FileUtil.normalize((String)this.pathToModule));
                content.append("')\n");
            }
            return content.toString();
        }

        private void writeSettingsFile(String newContent, String originalContent) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try (BufferedOutputStream out = new BufferedOutputStream(this.settingsFile.getOutputStream((Object)this));){
                    ((OutputStream)out).write(newContent.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException ex) {
                    this.cleanupAfterError();
                    try (BufferedOutputStream out2 = new BufferedOutputStream(this.settingsFile.getOutputStream((Object)this));){
                        ((OutputStream)out2).write(originalContent.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        private void cleanupAfterError() {
            this.errorDuringOperation.set(true);
            GradleUtils.addCoeditTransformedProject(this.project);
            try {
                if (this.buildFile != null) {
                    this.buildFile.delete((Object)this);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

