/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.sdk.FlutterSdk;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterErrorReportSubmitter
extends ErrorReportSubmitter {
    private static final Logger LOG = Logger.getInstance(FlutterErrorReportSubmitter.class);
    private static final String[] KNOWN_ERRORS = new String[]{"Bad state: No element"};

    @NotNull
    public String getReportActionText() {
        return "Create Flutter Bug Report";
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @NotNull Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> consumer) {
        if (parentComponent == null) {
            FlutterErrorReportSubmitter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            FlutterErrorReportSubmitter.$$$reportNull$$$0(1);
        }
        if (events == null) {
            FlutterErrorReportSubmitter.$$$reportNull$$$0(2);
        }
        if (events.length == 0) {
            FlutterErrorReportSubmitter.fail(consumer);
            return false;
        }
        String stackTrace = null;
        String errorMessage = null;
        block0: for (IdeaLoggingEvent event : events) {
            String message;
            int start;
            String stackTraceText = event.getThrowableText();
            if (!stackTraceText.startsWith("java.util.concurrent.CompletionException: java.io.IOException: ") || !(stackTraceText = stackTraceText.substring("java.util.concurrent.CompletionException: java.io.IOException: ".length())).startsWith("error from") || (start = (message = stackTraceText.substring("error from".length())).indexOf(": ") + 2) == 0) continue;
            int end = message.indexOf(10);
            if (end < 0) {
                end = message.length();
            }
            String error = message.substring(start, end);
            stackTrace = message.substring(end + 1);
            String[] stringArray = KNOWN_ERRORS;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String err = stringArray[i];
                if (!error.contains(err) || end == message.length()) continue;
                errorMessage = err;
                int endOfDartStack = stackTrace.indexOf("\\n\"\n");
                if (endOfDartStack <= 0) continue block0;
                stackTrace = stackTrace.substring(1, endOfDartStack);
                continue block0;
            }
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(parentComponent);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            FlutterErrorReportSubmitter.fail(consumer);
            return false;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Please file this bug report at ");
        builder.append("https://github.com/flutter/flutter-intellij/issues/new");
        builder.append(".\n");
        builder.append("\n");
        builder.append("---\n");
        builder.append("\n");
        builder.append("## What happened\n");
        builder.append("\n");
        if (additionalInfo != null) {
            builder.append(additionalInfo.trim()).append("\n");
        } else {
            builder.append("(please describe what you were doing when this exception occurred)\n");
        }
        builder.append("\n");
        builder.append("## Version information\n");
        builder.append("\n");
        ApplicationInfo info = ApplicationInfo.getInstance();
        builder.append(info.getVersionName()).append(" `").append(info.getFullVersion()).append("`");
        PluginId pid = FlutterUtils.getPluginId();
        IdeaPluginDescriptor flutterPlugin = PluginManagerCore.getPlugin((PluginId)pid);
        builder.append(" \u2022 Flutter plugin `").append(pid.getIdString()).append(' ').append(flutterPlugin.getVersion()).append("`");
        IdeaPluginDescriptor dartPlugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"Dart"));
        if (dartPlugin != null) {
            builder.append(" \u2022 Dart plugin `").append(dartPlugin.getVersion()).append("`");
        }
        builder.append("\n\n");
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
        if (sdk == null) {
            builder.append("No Flutter sdk configured.\n");
        } else {
            IdeaLoggingEvent[] flutterVersion = FlutterErrorReportSubmitter.getFlutterVersion(sdk);
            if (flutterVersion != null) {
                builder.append(flutterVersion.trim()).append("\n");
            } else {
                builder.append("Error getting Flutter sdk information.\n");
            }
        }
        builder.append("\n");
        if (stackTrace == null) {
            for (IdeaLoggingEvent event : events) {
                builder.append("## Exception\n");
                builder.append("\n");
                builder.append(event.getMessage()).append("\n");
                builder.append("\n");
                if (event.getThrowable() == null) continue;
                builder.append("```\n");
                builder.append(event.getThrowableText().trim()).append("\n");
                builder.append("```\n");
                builder.append("\n");
            }
        } else {
            builder.append("## Exception\n");
            builder.append("\n");
            builder.append(errorMessage).append("\n");
            builder.append("\n");
            builder.append("```\n");
            builder.append(stackTrace.replaceAll("\\\\n", "\n")).append("\n");
            builder.append("```\n");
            builder.append("\n");
        }
        for (IdeaLoggingEvent event : events) {
            FlutterInitializer.getAnalytics().sendException(event.getThrowableText(), false);
        }
        String text = builder.toString().trim() + "\n";
        ScratchRootType scratchRoot = ScratchRootType.getInstance();
        VirtualFile file = scratchRoot.createScratchFile(project, "bug-report.md", (Language)PlainTextLanguage.INSTANCE, text);
        if (file == null) {
            FlutterErrorReportSubmitter.fail(consumer);
            return false;
        }
        new OpenFileDescriptor(project, file).navigate(true);
        consumer.consume((Object)new SubmittedReportInfo(null, "", SubmittedReportInfo.SubmissionStatus.NEW_ISSUE));
        return true;
    }

    private static String getFlutterVersion(FlutterSdk sdk) {
        try {
            String flutterPath = sdk.getHomePath() + "/bin/flutter";
            ProcessBuilder builder = new ProcessBuilder(flutterPath, "--version");
            Process process = builder.start();
            if (!process.waitFor(3L, TimeUnit.SECONDS)) {
                return null;
            }
            return new String(FlutterErrorReportSubmitter.readFully(process.getInputStream()), StandardCharsets.UTF_8);
        }
        catch (IOException | InterruptedException ioe) {
            return null;
        }
    }

    private static void fail(@NotNull Consumer<SubmittedReportInfo> consumer) {
        if (consumer == null) {
            FlutterErrorReportSubmitter.$$$reportNull$$$0(3);
        }
        consumer.consume((Object)new SubmittedReportInfo(null, null, SubmittedReportInfo.SubmissionStatus.FAILED));
    }

    private static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] temp = new byte[4096];
        int count = in.read(temp);
        while (count > 0) {
            out.write(temp, 0, count);
            count = in.read(temp);
        }
        return out.toByteArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "io/flutter/FlutterErrorReportSubmitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "submit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fail";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

