/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.google.common.annotations.VisibleForTesting;
import com.google.dart.server.AnalysisServerListener;
import com.intellij.ProjectTopics;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.analytics.Analytics;
import io.flutter.analytics.FlutterAnalysisServerListener;
import io.flutter.analytics.ToolWindowTracker;
import io.flutter.android.IntelliJAndroidSdk;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.editor.FlutterSaveActionsManager;
import io.flutter.logging.FlutterConsoleLogManager;
import io.flutter.module.FlutterModuleBuilder;
import io.flutter.perf.FlutterWidgetPerfManager;
import io.flutter.performance.FlutterPerformanceViewFactory;
import io.flutter.preview.PreviewViewFactory;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.run.FlutterReloadManager;
import io.flutter.run.FlutterRunNotifications;
import io.flutter.run.daemon.DevToolsService;
import io.flutter.run.daemon.DeviceService;
import io.flutter.sdk.FlutterPluginsLibraryManager;
import io.flutter.settings.FlutterSettings;
import io.flutter.survey.FlutterSurveyNotifications;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.view.FlutterViewFactory;
import java.util.List;
import java.util.UUID;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class FlutterInitializer
implements StartupActivity {
    private static final String analyticsClientIdKey = "io.flutter.analytics.clientId";
    private static final String analyticsOptOutKey = "io.flutter.analytics.optOut";
    private static final String analyticsToastShown = "io.flutter.analytics.toastShown";
    private static Analytics analytics;
    private boolean toolWindowsInitialized = false;

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            FlutterInitializer.$$$reportNull$$$0(0);
        }
        if (FlutterModuleUtils.convertFromDeprecatedModuleType(project)) {
            FlutterMessages.showInfo(FlutterBundle.message("flutter.initializer.module.converted.title", new Object[0]), "Converted from 'WEB_MODULE' to '" + FlutterModuleUtils.getModuleTypeIDForFlutter() + "'.", project);
        }
        FlutterUtils.disableGradleProjectMigrationNotification(project);
        DeviceService.getInstance(project);
        DevToolsService.getInstance(project);
        boolean hasFlutterModule = false;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            boolean declaresFlutter = FlutterModuleUtils.declaresFlutter(module);
            boolean bl = hasFlutterModule = hasFlutterModule || declaresFlutter;
            if (!declaresFlutter) continue;
            FlutterModuleUtils.enableDartSDK(module);
            for (PubRoot root : PubRoots.forModule(module)) {
                if (root.hasAndroidModule(project)) {
                    this.ensureAndroidSdk(project);
                }
                FlutterModuleUtils.autoCreateRunConfig(project, root);
                if (FileEditorManager.getInstance((Project)project).getOpenFiles().length != 0) continue;
                FlutterModuleUtils.autoShowMain(project, root);
            }
        }
        if (hasFlutterModule || WorkspaceCache.getInstance(project).isBazel()) {
            this.initializeToolWindows(project);
        } else {
            project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (module == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!FlutterInitializer.this.toolWindowsInitialized && FlutterModuleUtils.isFlutterModule(module)) {
                        FlutterInitializer.this.initializeToolWindows(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "module";
                            break;
                        }
                    }
                    objectArray[1] = "io/flutter/FlutterInitializer$1";
                    objectArray[2] = "moduleAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (hasFlutterModule && PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.android")) != null && !FlutterModuleUtils.hasAndroidModule(project)) {
            List<Module> modules = FlutterModuleUtils.findModulesWithFlutterContents(project);
            for (Module module : modules) {
                VirtualFile moduleFile;
                if (module.isDisposed() || !FlutterModuleUtils.isFlutterModule(module) || (moduleFile = module.getModuleFile()) == null) continue;
                VirtualFile baseDir = moduleFile.getParent();
                if (baseDir.getName().equals(".idea")) {
                    baseDir = baseDir.getParent();
                }
                boolean isModule = false;
                try {
                    FlutterModuleBuilder.addAndroidModule(project, null, baseDir.getPath(), module.getName(), isModule);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            FlutterModuleUtils.ensureRunConfigSelected(project);
        }
        if (hasFlutterModule) {
            FlutterInitializer.performAndroidStudioCanaryCheck(project);
        }
        FlutterRunNotifications.init(project);
        FlutterSurveyNotifications.init(project);
        FlutterWidgetPerfManager.init(project);
        FlutterReloadManager.init(project);
        FlutterSaveActionsManager.init(project);
        FlutterPluginsLibraryManager libraryManager = new FlutterPluginsLibraryManager(project);
        libraryManager.startWatching();
        NotificationsConfiguration.getNotificationsConfiguration().register("Flutter Usage Statistics", NotificationDisplayType.STICKY_BALLOON, false);
        FlutterConsoleLogManager.initConsolePreferences();
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (!properties.getBoolean(analyticsToastShown)) {
            properties.setValue(analyticsToastShown, true);
            final Notification notification = new Notification("Flutter Usage Statistics", "Welcome to Flutter!", FlutterBundle.message("flutter.analytics.notification.content", new Object[0]), NotificationType.INFORMATION, (notification1, event) -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "url".equals(event.getDescription())) {
                    BrowserUtil.browse((String)"https://www.google.com/policies/privacy/");
                }
            });
            final boolean finalHasFlutterModule = hasFlutterModule;
            notification.addAction(new AnAction("Sounds good!"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    notification.expire();
                    if (finalHasFlutterModule) {
                        FlutterInitializer.enableAnalytics(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/FlutterInitializer$2", "actionPerformed"));
                }
            });
            notification.addAction(new AnAction("No thanks"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    notification.expire();
                    FlutterInitializer.setCanReportAnalytics(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/FlutterInitializer$3", "actionPerformed"));
                }
            });
            Notifications.Bus.notify((Notification)notification, (Project)project);
        } else if (hasFlutterModule) {
            FlutterInitializer.enableAnalytics(project);
        }
    }

    private static void enableAnalytics(@NotNull Project project) {
        if (project == null) {
            FlutterInitializer.$$$reportNull$$$0(1);
        }
        ToolWindowTracker.track(project, FlutterInitializer.getAnalytics());
        DartAnalysisServerService.getInstance((Project)project).addAnalysisServerListener((AnalysisServerListener)FlutterAnalysisServerListener.getInstance(project));
    }

    private void initializeToolWindows(@NotNull Project project) {
        if (project == null) {
            FlutterInitializer.$$$reportNull$$$0(2);
        }
        FlutterViewFactory.init(project);
        FlutterPerformanceViewFactory.init(project);
        PreviewViewFactory.init(project);
        this.toolWindowsInitialized = true;
    }

    private void ensureAndroidSdk(@NotNull Project project) {
        if (project == null) {
            FlutterInitializer.$$$reportNull$$$0(3);
        }
        if (ProjectRootManager.getInstance((Project)project).getProjectSdk() != null) {
            return;
        }
        IntelliJAndroidSdk wanted = IntelliJAndroidSdk.fromEnvironment();
        if (wanted == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> wanted.setCurrent(project));
    }

    @VisibleForTesting
    public static void setAnalytics(Analytics inAnalytics) {
        analytics = inAnalytics;
    }

    @NotNull
    public static Analytics getAnalytics() {
        if (analytics == null) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String clientId = properties.getValue(analyticsClientIdKey);
            if (clientId == null) {
                clientId = UUID.randomUUID().toString();
                properties.setValue(analyticsClientIdKey, clientId);
            }
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)FlutterUtils.getPluginId());
            assert (descriptor != null);
            ApplicationInfo info = ApplicationInfo.getInstance();
            analytics = new Analytics(clientId, descriptor.getVersion(), info.getVersionName(), info.getFullVersion());
            analytics.setCanSend(FlutterInitializer.getCanReportAnalytics());
            analytics.sendScreenView("main");
            FlutterSettings.getInstance().sendSettingsToAnalytics(analytics);
        }
        Analytics analytics = FlutterInitializer.analytics;
        if (analytics == null) {
            FlutterInitializer.$$$reportNull$$$0(4);
        }
        return analytics;
    }

    public static boolean getCanReportAnalytics() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        return !properties.getBoolean(analyticsOptOutKey, false);
    }

    public static void setCanReportAnalytics(boolean canReportAnalytics) {
        if (FlutterInitializer.getCanReportAnalytics() != canReportAnalytics) {
            boolean wasReporting = FlutterInitializer.getCanReportAnalytics();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            properties.setValue(analyticsOptOutKey, !canReportAnalytics);
            if (analytics != null) {
                analytics.setCanSend(FlutterInitializer.getCanReportAnalytics());
            }
            if (!wasReporting && canReportAnalytics) {
                FlutterInitializer.getAnalytics().sendScreenView("main");
            }
        }
    }

    public static void sendAnalyticsAction(@NotNull AnAction action) {
        if (action == null) {
            FlutterInitializer.$$$reportNull$$$0(5);
        }
        FlutterInitializer.sendAnalyticsAction(action.getClass().getSimpleName());
    }

    public static void sendAnalyticsAction(@NotNull String name) {
        if (name == null) {
            FlutterInitializer.$$$reportNull$$$0(6);
        }
        FlutterInitializer.getAnalytics().sendEvent("intellij", name);
    }

    private static void performAndroidStudioCanaryCheck(Project project) {
        if (!FlutterUtils.isAndroidStudio()) {
            return;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        if (info.getFullVersion().contains("Canary") && !info.getBuild().isSnapshot()) {
            FlutterMessages.showWarning("Unsupported Android Studio version", "Canary versions of Android Studio are not supported by the Flutter plugin.", project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/FlutterInitializer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/FlutterInitializer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalytics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enableAnalytics";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initializeToolWindows";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureAndroidSdk";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sendAnalyticsAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

