/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.google.common.base.Charsets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.psi.DartFile;
import io.flutter.FlutterConstants;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRootCache;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.view.EmbeddedBrowser;
import io.flutter.view.EmbeddedJcefBrowser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class FlutterUtils {
    private static final Pattern VALID_ID = Pattern.compile("[_a-zA-Z$][_a-zA-Z0-9$]*");
    private static final Pattern VALID_PACKAGE = Pattern.compile("^([a-z]++([_]?[a-z0-9]+)*)++$");

    private FlutterUtils() {
    }

    public static void invokeAndWait(@NotNull Runnable runnable) throws ProcessCanceledException {
        if (runnable == null) {
            FlutterUtils.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.defaultModalityState());
    }

    public static boolean isFlutteryFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlutterUtils.$$$reportNull$$$0(1);
        }
        return FlutterUtils.isDartFile(file) || PubRoot.isPubspec(file);
    }

    public static boolean couldContainWidgets(@Nullable VirtualFile file) {
        if (file instanceof LightVirtualFile) {
            return false;
        }
        return file != null && FlutterUtils.isDartFile(file);
    }

    public static boolean isDartFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlutterUtils.$$$reportNull$$$0(2);
        }
        return Objects.equals(file.getFileType(), DartFileType.INSTANCE);
    }

    public static boolean isAndroidStudio() {
        return StringUtil.equals((CharSequence)PlatformUtils.getPlatformPrefix(), (CharSequence)"AndroidStudio");
    }

    public static void warn(Logger logger, @NotNull Throwable t) {
        if (t == null) {
            FlutterUtils.$$$reportNull$$$0(3);
        }
        logger.warn(t);
    }

    public static void warn(Logger logger, String message) {
        logger.warn(message);
    }

    public static void warn(Logger logger, String message, @NotNull Throwable t) {
        if (t == null) {
            FlutterUtils.$$$reportNull$$$0(4);
        }
        logger.warn(message, t);
    }

    private static int getBaselineVersion() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        if (appInfo != null) {
            return appInfo.getBuild().getBaselineVersion();
        }
        return -1;
    }

    public static void disableGradleProjectMigrationNotification(@NotNull Project project) {
        if (project == null) {
            FlutterUtils.$$$reportNull$$$0(5);
        }
        String showMigrateToGradlePopup = "show.migrate.to.gradle.popup";
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        if (properties.getValue("show.migrate.to.gradle.popup") == null) {
            properties.setValue("show.migrate.to.gradle.popup", "false");
        }
    }

    public static boolean exists(@Nullable VirtualFile file) {
        return file != null && file.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInFlutterProject(@NotNull Project project, @NotNull PsiElement element) {
        PubRoot pubRoot;
        PsiFile file;
        if (project == null) {
            FlutterUtils.$$$reportNull$$$0(6);
        }
        if (element == null) {
            FlutterUtils.$$$reportNull$$$0(7);
        }
        if ((file = element.getContainingFile()) == null) {
            if (!(element instanceof PsiDirectory)) return false;
            pubRoot = PubRootCache.getInstance(project).getRoot(((PsiDirectory)element).getVirtualFile());
        } else {
            pubRoot = PubRootCache.getInstance(project).getRoot(file);
        }
        if (pubRoot != null) return pubRoot.declaresFlutter();
        return false;
    }

    public static boolean isInTestDir(@Nullable DartFile file) {
        if (file == null) {
            return false;
        }
        PubRoot root = PubRootCache.getInstance(file.getProject()).getRoot(file.getVirtualFile().getParent());
        if (root == null) {
            return false;
        }
        VirtualFile dir = file.getVirtualFile().getParent();
        if (dir == null) {
            return false;
        }
        Module module = root.getModule(file.getProject());
        if (!root.hasTests(dir) && !FlutterUtils.isInTestOrSourceRoot(module, file)) {
            return false;
        }
        return FlutterModuleUtils.isFlutterModule(module);
    }

    private static boolean isInTestOrSourceRoot(@Nullable Module module, @NotNull DartFile file) {
        if (file == null) {
            FlutterUtils.$$$reportNull$$$0(8);
        }
        if (module == null) {
            return false;
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        if (manager == null) {
            return false;
        }
        ContentEntry[] entries = manager.getContentEntries();
        VirtualFile virtualFile = file.getContainingFile().getVirtualFile();
        boolean foundSourceRoot = false;
        block0: for (ContentEntry entry : entries) {
            for (SourceFolder folder : entry.getSourceFolders()) {
                VirtualFile folderFile = folder.getFile();
                if (folderFile == null || !folderFile.equals(VfsUtil.getCommonAncestor((VirtualFile)folderFile, (VirtualFile)virtualFile))) continue;
                if (folder.getRootType().isForTests()) {
                    return true;
                }
                foundSourceRoot = true;
                continue block0;
            }
        }
        return foundSourceRoot && file.getName().endsWith("_test.dart") && FlutterSettings.getInstance().isAllowTestsInSourcesRoot();
    }

    public static boolean isIntegrationTestingMode() {
        return System.getProperty("idea.required.plugins.id", "").equals("io.flutter.tests.gui.flutter-gui-tests");
    }

    @Nullable
    public static VirtualFile getRealVirtualFile(@Nullable PsiFile psiFile) {
        return psiFile != null ? psiFile.getOriginalFile().getVirtualFile() : null;
    }

    @NotNull
    public static VirtualFile getProjectRoot(@NotNull Project project) {
        if (project == null) {
            FlutterUtils.$$$reportNull$$$0(9);
        }
        assert (!project.isDefault());
        @SystemIndependent String path = project.getBasePath();
        assert (path != null);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile virtualFile = Objects.requireNonNull(file);
        if (virtualFile == null) {
            FlutterUtils.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @Nullable
    public static DartFile getDartFile(@Nullable PsiElement elt) {
        if (elt == null) {
            return null;
        }
        PsiFile psiFile = elt.getContainingFile();
        if (!(psiFile instanceof DartFile)) {
            return null;
        }
        return (DartFile)psiFile;
    }

    public static void openFlutterSettings(@Nullable Project project) {
        ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"flutter.settings", (String)"");
    }

    public static boolean isDartKeyword(@NotNull String string) {
        if (string == null) {
            FlutterUtils.$$$reportNull$$$0(11);
        }
        return FlutterConstants.DART_KEYWORDS.contains(string);
    }

    public static boolean isValidDartIdentifier(@NotNull String id) {
        if (id == null) {
            FlutterUtils.$$$reportNull$$$0(12);
        }
        return VALID_ID.matcher(id).matches();
    }

    public static boolean isValidPackageName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(13);
        }
        return VALID_PACKAGE.matcher(name).matches();
    }

    public static boolean isXcodeFileName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(14);
        }
        return FlutterUtils.isXcodeProjectFileName(name) || FlutterUtils.isXcodeWorkspaceFileName(name);
    }

    public static boolean isXcodeProjectFileName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(15);
        }
        return name.endsWith(".xcodeproj");
    }

    public static boolean isXcodeWorkspaceFileName(@NotNull String name) {
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(16);
        }
        return name.endsWith(".xcworkspace");
    }

    public static boolean runsCleanly(@NotNull GeneralCommandLine cmd) {
        if (cmd == null) {
            FlutterUtils.$$$reportNull$$$0(17);
        }
        try {
            return ExecUtil.execAndGetOutput((GeneralCommandLine)cmd).getExitCode() == 0;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @NotNull
    public static PluginId getPluginId() {
        PluginId pluginId = PluginId.findId((String[])new String[]{"io.flutter", ""});
        assert (pluginId != null);
        PluginId pluginId2 = pluginId;
        if (pluginId2 == null) {
            FlutterUtils.$$$reportNull$$$0(18);
        }
        return pluginId2;
    }

    @Nullable
    public static IdeaPluginDescriptor getPluginDescriptor(@NotNull String pluginId) {
        if (pluginId == null) {
            FlutterUtils.$$$reportNull$$$0(19);
        }
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (!descriptor.getPluginId().getIdString().equals(pluginId)) continue;
            return descriptor;
        }
        return null;
    }

    public static FlutterPubspecInfo getFlutterPubspecInfo(@NotNull VirtualFile pubspec) {
        if (pubspec == null) {
            FlutterUtils.$$$reportNull$$$0(20);
        }
        FlutterPubspecInfo info = new FlutterPubspecInfo(pubspec.getModificationStamp());
        try {
            Map<String, Object> yamlMap = FlutterUtils.readPubspecFileToMap(pubspec);
            if (yamlMap != null) {
                Object flutterEntry;
                Object dependencies;
                Object packageName = yamlMap.get("name");
                if ("flutter".equals(packageName)) {
                    info.flutter = true;
                }
                if ((dependencies = yamlMap.get("dependencies")) instanceof Map) {
                    info.flutter |= ((Map)dependencies).containsKey("flutter");
                }
                if ((flutterEntry = yamlMap.get("flutter")) instanceof Map) {
                    info.plugin = ((Map)flutterEntry).containsKey("plugin");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    public static boolean declaresFlutter(@NotNull VirtualFile pubspec) {
        if (pubspec == null) {
            FlutterUtils.$$$reportNull$$$0(21);
        }
        return FlutterUtils.getFlutterPubspecInfo(pubspec).declaresFlutter();
    }

    public static boolean isFlutterPlugin(@NotNull VirtualFile pubspec) {
        if (pubspec == null) {
            FlutterUtils.$$$reportNull$$$0(22);
        }
        return FlutterUtils.getFlutterPubspecInfo(pubspec).isFlutterPlugin();
    }

    @Nullable
    public static Project findProject(@NotNull String path) {
        if (path == null) {
            FlutterUtils.$$$reportNull$$$0(23);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((Path)Paths.get(path, new String[0]), (Project)project)) continue;
            return project;
        }
        return null;
    }

    private static Map<String, Object> readPubspecFileToMap(@NotNull VirtualFile pubspec) throws IOException {
        if (pubspec == null) {
            FlutterUtils.$$$reportNull$$$0(24);
        }
        String contents = new String(pubspec.contentsToByteArray(true));
        return FlutterUtils.loadPubspecInfo(contents);
    }

    private static Map<String, Object> loadPubspecInfo(@NotNull String yamlContents) {
        if (yamlContents == null) {
            FlutterUtils.$$$reportNull$$$0(25);
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()), new Representer(new DumperOptions()), new DumperOptions(), new Resolver(){

            protected void addImplicitResolvers() {
                this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
                this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
                this.addImplicitResolver(Tag.NULL, EMPTY, null);
                this.addImplicitResolver(new Tag("tag:yaml.org,2002:value"), VALUE, "=");
                this.addImplicitResolver(Tag.MERGE, MERGE, "<");
            }
        });
        try {
            return (Map)yaml.load(yamlContents);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isAndroidxProject(@NotNull Project project) {
        if (project == null) {
            FlutterUtils.$$$reportNull$$$0(26);
        }
        @SystemIndependent String basePath = project.getBasePath();
        assert (basePath != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(basePath);
        assert (projectDir != null);
        VirtualFile androidDir = FlutterUtils.getFlutterManagedAndroidDir(projectDir);
        if (androidDir == null && (androidDir = FlutterUtils.getAndroidProjectDir(projectDir)) == null) {
            return false;
        }
        VirtualFile propFile = androidDir.findChild("gradle.properties");
        if (propFile == null) {
            return false;
        }
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(propFile.getInputStream(), Charsets.UTF_8));
        }
        catch (IOException ex) {
            return false;
        }
        String value = properties.getProperty("android.useAndroidX");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private static VirtualFile getAndroidProjectDir(VirtualFile dir) {
        return dir.findChild("app") == null ? null : dir;
    }

    @Nullable
    private static VirtualFile getFlutterManagedAndroidDir(VirtualFile dir) {
        VirtualFile android;
        VirtualFile meta = dir.findChild(".metadata");
        if (meta != null) {
            try {
                Properties properties = new Properties();
                properties.load(new InputStreamReader(meta.getInputStream(), Charsets.UTF_8));
                String value = properties.getProperty("project_type");
                if (value == null) {
                    return null;
                }
                switch (value) {
                    case "app": {
                        return dir.findChild("android");
                    }
                    case "module": {
                        return dir.findChild(".android");
                    }
                    case "package": {
                        return null;
                    }
                    case "plugin": {
                        return dir.findFileByRelativePath("example/android");
                    }
                }
            }
            catch (IOException properties) {
                // empty catch block
            }
        }
        if ((android = dir.findChild(".android")) != null) {
            return android;
        }
        android = dir.findChild("android");
        if (android != null) {
            return android;
        }
        android = dir.findFileByRelativePath("example/android");
        if (android != null) {
            return android;
        }
        return null;
    }

    @Nullable
    public static Module findModuleNamed(@NotNull Project project, @NotNull String name) {
        Module[] modules;
        if (project == null) {
            FlutterUtils.$$$reportNull$$$0(27);
        }
        if (name == null) {
            FlutterUtils.$$$reportNull$$$0(28);
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    public static String flutterGradleModuleName(Project project) {
        return project.getName().replaceAll(" ", "_") + ".flutter";
    }

    @Nullable
    public static Module findFlutterGradleModule(@NotNull Project project) {
        String moduleName;
        Module module;
        if (project == null) {
            FlutterUtils.$$$reportNull$$$0(29);
        }
        if ((module = FlutterUtils.findModuleNamed(project, moduleName = "flutter")) == null && (module = FlutterUtils.findModuleNamed(project, moduleName = FlutterUtils.flutterGradleModuleName(project))) == null) {
            return null;
        }
        VirtualFile file = FlutterUtils.locateModuleRoot(module);
        if (file == null) {
            return null;
        }
        VirtualFile meta = (file = file.getParent().getParent()).findChild(".metadata");
        if (meta == null) {
            return null;
        }
        VirtualFile android = FlutterUtils.getFlutterManagedAndroidDir(meta.getParent());
        if (android != null && android.getName().equals(".android")) {
            return module;
        }
        return null;
    }

    @Nullable
    public static VirtualFile locateModuleRoot(@NotNull Module module) {
        ModuleSourceOrderEntry entry;
        if (module == null) {
            FlutterUtils.$$$reportNull$$$0(30);
        }
        if ((entry = FlutterUtils.findModuleSourceEntry(module)) == null) {
            return null;
        }
        VirtualFile[] roots = entry.getRootModel().getContentRoots();
        if (roots.length == 0) {
            return null;
        }
        return roots[0];
    }

    @Nullable
    private static ModuleSourceOrderEntry findModuleSourceEntry(@NotNull Module module) {
        OrderEntry[] orderEntries;
        if (module == null) {
            FlutterUtils.$$$reportNull$$$0(31);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
            if (!(entry instanceof ModuleSourceOrderEntry)) continue;
            return (ModuleSourceOrderEntry)entry;
        }
        return null;
    }

    @Nullable
    public static EmbeddedBrowser embeddedBrowser(Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        return EmbeddedJcefBrowser.getInstance(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/FlutterUtils";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspec";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlContents";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/FlutterUtils";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRoot";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFlutteryFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDartFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableGradleProjectMigrationNotification";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInFlutterProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInTestOrSourceRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoot";
                break;
            }
            case 10: 
            case 18: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDartKeyword";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidDartIdentifier";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidPackageName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isXcodeFileName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isXcodeProjectFileName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isXcodeWorkspaceFileName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runsCleanly";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFlutterPubspecInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "declaresFlutter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isFlutterPlugin";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readPubspecFileToMap";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadPubspecInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidxProject";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findModuleNamed";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findFlutterGradleModule";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "locateModuleRoot";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findModuleSourceEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 18 -> new IllegalStateException(string);
        };
    }

    public static class FlutterPubspecInfo {
        private final long modificationStamp;
        private boolean flutter = false;
        private boolean plugin = false;

        FlutterPubspecInfo(long modificationStamp) {
            this.modificationStamp = modificationStamp;
        }

        public boolean declaresFlutter() {
            return this.flutter;
        }

        public boolean isFlutterPlugin() {
            return this.plugin;
        }

        public long getModificationStamp() {
            return this.modificationStamp;
        }
    }
}

