/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import io.flutter.FlutterMessages;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class NotificationManager {
    private static final Set<String> shownNotifications = new HashSet<String>();

    public static void showError(String title, String message, @Nullable String id, @Nullable Boolean showOnce) {
        if (NotificationManager.shouldNotify(id, showOnce)) {
            shownNotifications.add(id);
            FlutterMessages.showError(title, message, null);
        }
    }

    public static void showWarning(String title, String message, @Nullable String id, @Nullable Boolean showOnce) {
        if (NotificationManager.shouldNotify(id, showOnce)) {
            shownNotifications.add(id);
            FlutterMessages.showWarning(title, message, null);
        }
    }

    public static void showInfo(String title, String message, @Nullable String id, @Nullable Boolean showOnce) {
        if (NotificationManager.shouldNotify(id, showOnce)) {
            shownNotifications.add(id);
            FlutterMessages.showInfo(title, message, null);
        }
    }

    private static boolean shouldNotify(@Nullable String id, @Nullable Boolean showOnce) {
        return id == null || !shownNotifications.contains(id) || showOnce == null || showOnce == false;
    }

    public static void reset() {
        shownNotifications.clear();
    }
}

