/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.analytics.TimeTracker;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.AndroidUtils;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.android.facet.AndroidFrameworkDetector;
import org.jetbrains.annotations.NotNull;

public class ProjectOpenActivity
implements StartupActivity,
DumbAware {
    public static final ProjectType FLUTTER_PROJECT_TYPE = new ProjectType("io.flutter");
    private static final Logger LOG = Logger.getInstance(ProjectOpenActivity.class);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ProjectOpenActivity.$$$reportNull$$$0(0);
        }
        TimeTracker.getInstance(project).onProjectOpen();
        if (!FlutterModuleUtils.declaresFlutter(project) && !WorkspaceCache.getInstance(project).isBazel()) {
            return;
        }
        ProjectOpenActivity.excludeAndroidFrameworkDetector(project);
        FlutterSdk sdk = FlutterSdk.getIncomplete(project);
        if (sdk == null) {
            return;
        }
        DumbService.getInstance((Project)project).runWhenSmart(() -> FlutterInitializer.getAnalytics().sendEventMetric("startup", "indexingFinished", ((TimeTracker)project.getService(TimeTracker.class)).millisSinceProjectOpen(), FlutterSdk.getFlutterSdk(project)));
        ApplicationManager.getApplication().executeOnPooledThread(() -> sdk.queryFlutterConfig("android-studio-dir", false));
        if (FlutterUtils.isAndroidStudio() && !FLUTTER_PROJECT_TYPE.equals((Object)ProjectTypeService.getProjectType((Project)project)) && !AndroidUtils.isAndroidProject(project)) {
            ProjectTypeService.setProjectType((Project)project, (ProjectType)FLUTTER_PROJECT_TYPE);
        }
        if (WorkspaceCache.getInstance(project).isBazel()) {
            return;
        }
        for (PubRoot pubRoot : PubRoots.forProject(project)) {
            if (pubRoot.hasUpToDatePackages()) continue;
            Notifications.Bus.notify((Notification)new PackagesOutOfDateNotification(project, pubRoot), (Project)project);
        }
    }

    private static void excludeAndroidFrameworkDetector(@NotNull Project project) {
        if (project == null) {
            ProjectOpenActivity.$$$reportNull$$$0(1);
        }
        if (FlutterUtils.isAndroidStudio()) {
            return;
        }
        if (PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.android")) == null) {
            return;
        }
        try {
            DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
            try {
                FrameworkType type = new AndroidFrameworkDetector().getFrameworkType();
                if (!excludesConfiguration.isExcludedFromDetection(type)) {
                    excludesConfiguration.addExcludedFramework(type);
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "io/flutter/ProjectOpenActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeAndroidFrameworkDetector";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PackagesOutOfDateNotification
    extends Notification {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PubRoot myRoot;

        public PackagesOutOfDateNotification(final @NotNull Project project, final @NotNull PubRoot root) {
            if (project == null) {
                PackagesOutOfDateNotification.$$$reportNull$$$0(0);
            }
            if (root == null) {
                PackagesOutOfDateNotification.$$$reportNull$$$0(1);
            }
            super("Flutter Packages", FlutterIcons.Flutter, "Flutter pub get.", null, "The pubspec.yaml file has been modified since the last time 'flutter pub get' was run.", NotificationType.INFORMATION, null);
            this.myProject = project;
            this.myRoot = root;
            this.addAction(new AnAction("Run 'flutter pub get'"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.expire();
                    FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
                    if (sdk == null) {
                        Messages.showErrorDialog((Project)project, (String)"Flutter SDK not found", (String)"Error");
                        return;
                    }
                    if (sdk.startPubGet(root, project) == null) {
                        Messages.showErrorDialog((String)"Unable to run 'flutter pub get'", (String)"Error");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/ProjectOpenActivity$PackagesOutOfDateNotification$1", "actionPerformed"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "io/flutter/ProjectOpenActivity$PackagesOutOfDateNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

