/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import io.flutter.FlutterConstants;
import io.flutter.FlutterInitializer;
import io.flutter.actions.FlutterSdkAction;
import io.flutter.actions.RunFlutterAction;
import io.flutter.bazel.Workspace;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.SdkAttachConfig;
import io.flutter.run.SdkRunConfig;
import io.flutter.run.bazel.BazelAttachConfig;
import io.flutter.run.bazel.BazelRunConfig;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachDebuggerAction
extends FlutterSdkAction {
    public static final Key<ThreeState> ATTACH_IS_ACTIVE = new Key("attach-is-active");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AttachDebuggerAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Override
    public void startCommand(@NotNull Project project, @NotNull FlutterSdk sdk, @Nullable PubRoot root, @NotNull DataContext context) {
        if (project == null) {
            AttachDebuggerAction.$$$reportNull$$$0(1);
        }
        if (sdk == null) {
            AttachDebuggerAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AttachDebuggerAction.$$$reportNull$$$0(3);
        }
        FlutterInitializer.sendAnalyticsAction((AnAction)this);
        RunConfiguration configuration = AttachDebuggerAction.findRunConfig(project);
        if (configuration == null) {
            RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
            if (settings == null) {
                AttachDebuggerAction.showSelectConfigDialog();
                return;
            }
            configuration = settings.getConfiguration();
            if (!(configuration instanceof SdkRunConfig)) {
                if (project.isDefault() || !FlutterSdkUtil.hasFlutterModules(project)) {
                    return;
                }
                AttachDebuggerAction.showSelectConfigDialog();
                return;
            }
        }
        SdkAttachConfig sdkRunConfig = new SdkAttachConfig((SdkRunConfig)configuration);
        sdkRunConfig.pubRoot = root;
        Executor executor = RunFlutterAction.getExecutor("Debug");
        if (executor == null) {
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)sdkRunConfig);
        ExecutionEnvironment env = builder.activeTarget().dataContext(context).build();
        FlutterLaunchMode.addToEnvironment(env, FlutterLaunchMode.DEBUG);
        if (project.getUserData(ATTACH_IS_ACTIVE) == null) {
            project.putUserData(ATTACH_IS_ACTIVE, (Object)ThreeState.fromBoolean((boolean)false));
            AttachDebuggerAction.onAttachTermination(project, p -> p.putUserData(ATTACH_IS_ACTIVE, null));
        }
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Override
    public void startCommandInBazelContext(@NotNull Project project, @NotNull Workspace workspace, @NotNull AnActionEvent event) {
        if (project == null) {
            AttachDebuggerAction.$$$reportNull$$$0(4);
        }
        if (workspace == null) {
            AttachDebuggerAction.$$$reportNull$$$0(5);
        }
        if (event == null) {
            AttachDebuggerAction.$$$reportNull$$$0(6);
        }
        FlutterInitializer.sendAnalyticsAction((AnAction)this);
        RunConfiguration configuration = AttachDebuggerAction.findRunConfig(project);
        if (configuration == null) {
            RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
            if (settings == null) {
                AttachDebuggerAction.showSelectConfigDialog();
                return;
            }
            configuration = settings.getConfiguration();
            if (!(configuration instanceof BazelRunConfig)) {
                return;
            }
        }
        BazelAttachConfig sdkRunConfig = new BazelAttachConfig((BazelRunConfig)configuration);
        Executor executor = RunFlutterAction.getExecutor("Debug");
        if (executor == null) {
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)sdkRunConfig);
        ExecutionEnvironment env = builder.activeTarget().dataContext(event.getDataContext()).build();
        FlutterLaunchMode.addToEnvironment(env, FlutterLaunchMode.DEBUG);
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Override
    public boolean enableActionInBazelContext() {
        return true;
    }

    public void update(AnActionEvent e) {
        RunnerAndConfigurationSettings settings;
        Project project = e.getProject();
        if (project == null || project.isDefault()) {
            super.update(e);
            return;
        }
        if (!FlutterSdkUtil.hasFlutterModules(project)) {
            e.getPresentation().setVisible(false);
            return;
        }
        RunConfiguration configuration = AttachDebuggerAction.findRunConfig(project);
        boolean enabled = configuration == null ? ((settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration()) == null ? false : (configuration = settings.getConfiguration()) instanceof SdkRunConfig || configuration instanceof BazelRunConfig) : true;
        if (enabled && project.getUserData(ATTACH_IS_ACTIVE) != null) {
            enabled = false;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(enabled);
    }

    @Nullable
    public static RunConfiguration findRunConfig(Project project) {
        RunManagerEx mgr = RunManagerEx.getInstanceEx((Project)project);
        List configs = mgr.getAllConfigurationsList();
        int count = 0;
        RunConfiguration sdkConfig = null;
        for (RunConfiguration config : configs) {
            if (!(config instanceof SdkRunConfig)) continue;
            ++count;
            sdkConfig = config;
        }
        return count == 1 ? sdkConfig : null;
    }

    private static void onAttachTermination(final @NotNull Project project, final @NotNull Consumer<Project> runner) {
        if (project == null) {
            AttachDebuggerAction.$$$reportNull$$$0(7);
        }
        if (runner == null) {
            AttachDebuggerAction.$$$reportNull$$$0(8);
        }
        final MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){
            Object handler;

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (env.getRunProfile() instanceof SdkAttachConfig) {
                    this.handler = handler;
                }
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (this.handler == handler) {
                    runner.accept(project);
                    connection.disconnect();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/actions/AttachDebuggerAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void showSelectConfigDialog() {
        ApplicationManager.getApplication().invokeLater(() -> new SelectConfigDialog().show(), ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/actions/AttachDebuggerAction";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/actions/AttachDebuggerAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startCommandInBazelContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onAttachTermination";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static class SelectConfigDialog
    extends DialogWrapper {
        private JPanel myPanel;
        private JTextPane myTextPane;

        SelectConfigDialog() {
            super(null, false, false);
            this.setTitle("Run Configuration");
            this.myPanel = new JPanel();
            this.myTextPane = new JTextPane();
            Messages.installHyperlinkSupport((JTextPane)this.myTextPane);
            String selectConfig = "<html><body><p>The run configuration for the Flutter module must be selected.<p>Please change the run configuration to the one created when the<br>module was created. See <a href=\"" + FlutterConstants.URL_RUN_AND_DEBUG + "\">the Flutter documentation</a> for more information.</body></html>";
            this.myTextPane.setText(selectConfig);
            this.myPanel.add(this.myTextPane);
            this.init();
            this.getButton(this.getCancelAction()).setVisible(false);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel;
        }
    }
}

