/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ModalityUiUtil;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.actions.OpenEmulatorAction;
import io.flutter.actions.OpenSimulatorAction;
import io.flutter.actions.RestartFlutterDaemonAction;
import io.flutter.run.FlutterDevice;
import io.flutter.run.daemon.DeviceService;
import io.flutter.sdk.AndroidEmulatorManager;
import io.flutter.utils.FlutterModuleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceSelectorAction
extends ComboBoxAction
implements DumbAware {
    private final List<AnAction> actions = new ArrayList<AnAction>();
    private final List<Project> knownProjects = Collections.synchronizedList(new ArrayList());
    private SelectDeviceAction selectedDeviceAction;

    DeviceSelectorAction() {
        this.setSmallVariant(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DeviceSelectorAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(this.actions);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            DeviceSelectorAction.$$$reportNull$$$0(1);
        }
        return defaultActionGroup;
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DeviceSelectorAction.$$$reportNull$$$0(2);
        }
        if (!DeviceSelectorAction.isSelectorVisible(project = e.getProject())) {
            e.getPresentation().setVisible(false);
            return;
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!this.knownProjects.contains(project)) {
            this.knownProjects.add(project);
            Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project closedProject) {
                    if (closedProject == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DeviceSelectorAction.this.knownProjects.remove(closedProject);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closedProject", "io/flutter/actions/DeviceSelectorAction$1", "projectClosed"));
                }
            });
            final Runnable deviceListener = () -> this.queueUpdate(project, e.getPresentation());
            DeviceService.getInstance(project).addListener(deviceListener);
            final Runnable emulatorListener = () -> this.queueUpdate(project, e.getPresentation());
            AndroidEmulatorManager.getInstance(project).addListener(emulatorListener);
            ProjectManager.getInstance().addProjectManagerListener(project, new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DeviceService.getInstance(project).removeListener(deviceListener);
                    AndroidEmulatorManager.getInstance(project).removeListener(emulatorListener);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/actions/DeviceSelectorAction$2", "projectClosing"));
                }
            });
            this.update(project, presentation);
        }
        DeviceService deviceService = DeviceService.getInstance(project);
        FlutterDevice selectedDevice = deviceService.getSelectedDevice();
        Collection<FlutterDevice> devices = deviceService.getConnectedDevices();
        if (devices.isEmpty()) {
            boolean isLoading;
            boolean bl = isLoading = deviceService.getStatus() == DeviceService.State.LOADING;
            if (isLoading) {
                presentation.setText(FlutterBundle.message("devicelist.loading", new Object[0]));
            } else {
                presentation.setText("<no devices>");
            }
        } else if (selectedDevice == null) {
            presentation.setText("<no device selected>");
        } else if (this.selectedDeviceAction != null) {
            Presentation template = this.selectedDeviceAction.getTemplatePresentation();
            presentation.setIcon(template.getIcon());
            presentation.setText(selectedDevice.presentationName());
            presentation.setEnabled(true);
        }
    }

    private void queueUpdate(@NotNull Project project, @NotNull Presentation presentation) {
        if (project == null) {
            DeviceSelectorAction.$$$reportNull$$$0(3);
        }
        if (presentation == null) {
            DeviceSelectorAction.$$$reportNull$$$0(4);
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> this.update(project, presentation));
    }

    private void update(@NotNull Project project, @NotNull Presentation presentation) {
        if (project == null) {
            DeviceSelectorAction.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            DeviceSelectorAction.$$$reportNull$$$0(6);
        }
        if (project.isDisposed()) {
            return;
        }
        this.updateActions(project, presentation);
        DeviceSelectorAction.updateVisibility(project, presentation);
    }

    private static void updateVisibility(Project project, Presentation presentation) {
        boolean visible = DeviceSelectorAction.isSelectorVisible(project);
        JComponent component = (JComponent)presentation.getClientProperty("customComponent");
        if (component != null) {
            component.setVisible(visible);
            if (component.getParent() != null) {
                component.getParent().doLayout();
                component.getParent().repaint();
            }
        }
    }

    private static boolean isSelectorVisible(@Nullable Project project) {
        if (project == null || !FlutterModuleUtils.hasFlutterModule(project)) {
            return false;
        }
        DeviceService deviceService = DeviceService.getInstance(project);
        return deviceService.isRefreshInProgress() || deviceService.getStatus() != DeviceService.State.INACTIVE;
    }

    private void updateActions(@NotNull Project project, Presentation presentation) {
        List<OpenEmulatorAction> emulatorActions;
        if (project == null) {
            DeviceSelectorAction.$$$reportNull$$$0(7);
        }
        this.actions.clear();
        DeviceService deviceService = DeviceService.getInstance(project);
        FlutterDevice selectedDevice = deviceService.getSelectedDevice();
        Collection<FlutterDevice> devices = deviceService.getConnectedDevices();
        this.selectedDeviceAction = null;
        for (FlutterDevice device : devices) {
            SelectDeviceAction deviceAction = new SelectDeviceAction(device, devices);
            this.actions.add(deviceAction);
            if (!Objects.equals(device, selectedDevice)) continue;
            this.selectedDeviceAction = deviceAction;
            Presentation template = deviceAction.getTemplatePresentation();
            presentation.setIcon(template.getIcon());
            presentation.setEnabled(true);
        }
        if (SystemInfo.isMac) {
            boolean simulatorOpen = false;
            for (AnAction action : this.actions) {
                if (!(action instanceof SelectDeviceAction)) continue;
                SelectDeviceAction deviceAction = (SelectDeviceAction)action;
                FlutterDevice device = deviceAction.device;
                if (!device.isIOS() || !device.emulator()) continue;
                simulatorOpen = true;
            }
            this.actions.add((AnAction)new Separator());
            this.actions.add(new OpenSimulatorAction(!simulatorOpen));
        }
        if (!(emulatorActions = OpenEmulatorAction.getEmulatorActions(project)).isEmpty()) {
            this.actions.add((AnAction)new Separator());
            this.actions.addAll(emulatorActions);
        }
        if (!FlutterModuleUtils.hasInternalDartSdkPath(project)) {
            this.actions.add((AnAction)new Separator());
            this.actions.add(new RestartFlutterDaemonAction());
        }
        ActivityTracker.getInstance().inc();
    }

    protected Condition<AnAction> getPreselectCondition() {
        return action -> action == this.selectedDeviceAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/actions/DeviceSelectorAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/actions/DeviceSelectorAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class SelectDeviceAction
    extends AnAction {
        @NotNull
        private final FlutterDevice device;

        SelectDeviceAction(@NotNull FlutterDevice device, @NotNull Collection<FlutterDevice> devices) {
            if (device == null) {
                SelectDeviceAction.$$$reportNull$$$0(0);
            }
            if (devices == null) {
                SelectDeviceAction.$$$reportNull$$$0(1);
            }
            super(device.getUniqueName(devices), null, FlutterIcons.Phone);
            this.device = device;
        }

        public String presentationName() {
            return this.device.presentationName();
        }

        public void actionPerformed(AnActionEvent e) {
            DeviceService service;
            Project project = e.getProject();
            DeviceService deviceService = service = project == null ? null : DeviceService.getInstance(project);
            if (service != null) {
                service.setSelectedDevice(this.device);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "device";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "devices";
                    break;
                }
            }
            objectArray[1] = "io/flutter/actions/DeviceSelectorAction$SelectDeviceAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

