/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import io.flutter.actions.ProjectActions;
import io.flutter.run.daemon.FlutterApp;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FlutterAppAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(FlutterAppAction.class);
    @NotNull
    private final FlutterApp myApp;
    @NotNull
    private final Computable<Boolean> myIsApplicable;
    @NotNull
    private final String myActionId;
    private final FlutterApp.FlutterAppListener myListener;
    private boolean myIsListening;

    public FlutterAppAction(@NotNull FlutterApp app, @NotNull String text, @NotNull String description, @NotNull Icon icon, @NotNull Computable<Boolean> isApplicable, @NotNull String actionId) {
        if (app == null) {
            FlutterAppAction.$$$reportNull$$$0(0);
        }
        if (text == null) {
            FlutterAppAction.$$$reportNull$$$0(1);
        }
        if (description == null) {
            FlutterAppAction.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            FlutterAppAction.$$$reportNull$$$0(3);
        }
        if (isApplicable == null) {
            FlutterAppAction.$$$reportNull$$$0(4);
        }
        if (actionId == null) {
            FlutterAppAction.$$$reportNull$$$0(5);
        }
        super(text, description, icon);
        this.myListener = new FlutterApp.FlutterAppListener(){

            @Override
            public void stateChanged(FlutterApp.State newState) {
                FlutterAppAction.this.getTemplatePresentation().setEnabled(FlutterAppAction.this.myApp.isStarted() && (Boolean)FlutterAppAction.this.myIsApplicable.compute() != false);
            }
        };
        this.myIsListening = false;
        this.myApp = app;
        this.myIsApplicable = isApplicable;
        this.myActionId = actionId;
        this.updateActionRegistration(app.isConnected());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FlutterAppAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    private void updateActionRegistration(boolean isConnected) {
        Project project = this.getApp().getProject();
        if (!isConnected) {
            if (ProjectActions.getAction(project, this.myActionId) == this) {
                ProjectActions.unregisterAction(project, this.myActionId);
            }
        } else if (ProjectActions.getAction(project, this.myActionId) != this) {
            ProjectActions.registerAction(project, this.myActionId, (AnAction)this);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FlutterAppAction.$$$reportNull$$$0(7);
        }
        this.updateActionRegistration(this.myApp.isConnected());
        boolean isConnected = (Boolean)this.myIsApplicable.compute();
        boolean supportsReload = this.myApp.getMode().supportsReload();
        e.getPresentation().setEnabled(this.myApp.isStarted() && isConnected && supportsReload);
        if (isConnected) {
            if (!this.myIsListening) {
                this.getApp().addStateListener(this.myListener);
                this.myIsListening = true;
            }
        } else if (this.myIsListening) {
            this.getApp().removeStateListener(this.myListener);
            this.myIsListening = false;
        }
    }

    @NotNull
    public FlutterApp getApp() {
        FlutterApp flutterApp = this.myApp;
        if (flutterApp == null) {
            FlutterAppAction.$$$reportNull$$$0(8);
        }
        return flutterApp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/actions/FlutterAppAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/actions/FlutterAppAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

