/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterMessages;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.ProgressHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterBuildActionGroup
extends DefaultActionGroup {
    public static void build(final @NotNull Project project, @NotNull PubRoot pubRoot, @NotNull FlutterSdk sdk, final @NotNull BuildType buildType, @Nullable String desc) {
        if (project == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(0);
        }
        if (pubRoot == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(1);
        }
        if (sdk == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(2);
        }
        if (buildType == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(3);
        }
        final ProgressHelper progressHelper = new ProgressHelper(project);
        progressHelper.start(desc == null ? "building" : desc);
        ProcessAdapter processAdapter = new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                progressHelper.done();
                int exitCode = event.getExitCode();
                if (exitCode != 0) {
                    FlutterMessages.showError("Error while building " + String.valueOf((Object)buildType), "`flutter build` returned: " + exitCode, project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/FlutterBuildActionGroup$1", "processTerminated"));
            }
        };
        Module module = pubRoot.getModule(project);
        if (module != null) {
            sdk.flutterBuild(pubRoot, buildType.type).startInModuleConsole(module, pubRoot::refresh, (ProcessListener)processAdapter);
        } else {
            ColoredProcessHandler processHandler = sdk.flutterBuild(pubRoot, buildType.type).startInConsole(project);
            if (processHandler == null) {
                progressHelper.done();
            } else {
                processHandler.addProcessListener((ProcessListener)processAdapter);
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(4);
        }
        Presentation presentation = event.getPresentation();
        boolean enabled = FlutterBuildActionGroup.isInFlutterModule(event);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    private static boolean isInFlutterModule(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(5);
        }
        if ((project = event.getProject()) == null) {
            return false;
        }
        return FlutterModuleUtils.hasFlutterModule(project);
    }

    @Nullable
    public static Module findFlutterModule(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(6);
        }
        if (file == null) {
            FlutterBuildActionGroup.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        if (FlutterModuleUtils.declaresFlutter(module)) {
            return module;
        }
        VirtualFile parent = ModuleRootManager.getInstance((Module)module).getContentRoots()[0].getParent();
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)parent, (Project)project)) == null) {
            return null;
        }
        return FlutterModuleUtils.declaresFlutter(module) ? module : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/FlutterBuildActionGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInFlutterModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findFlutterModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum BuildType {
        AAR("aar"),
        APK("apk"),
        APP_BUNDLE("appbundle"),
        IOS("ios"),
        WEB("web");

        public final String type;

        private BuildType(String type) {
            this.type = type;
        }
    }

    public static class Web
    extends FlutterBuildAction {
        @Override
        @NotNull
        protected BuildType buildType() {
            BuildType buildType = BuildType.WEB;
            if (buildType == null) {
                Web.$$$reportNull$$$0(0);
            }
            return buildType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/actions/FlutterBuildActionGroup$Web", "buildType"));
        }
    }

    public static class Ios
    extends FlutterBuildAction {
        @Override
        @NotNull
        protected BuildType buildType() {
            BuildType buildType = BuildType.IOS;
            if (buildType == null) {
                Ios.$$$reportNull$$$0(0);
            }
            return buildType;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                Ios.$$$reportNull$$$0(1);
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(SystemInfo.isMac);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/actions/FlutterBuildActionGroup$Ios";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/actions/FlutterBuildActionGroup$Ios";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class AppBundle
    extends FlutterBuildAction {
        @Override
        @NotNull
        protected BuildType buildType() {
            BuildType buildType = BuildType.APP_BUNDLE;
            if (buildType == null) {
                AppBundle.$$$reportNull$$$0(0);
            }
            return buildType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/actions/FlutterBuildActionGroup$AppBundle", "buildType"));
        }
    }

    public static class APK
    extends FlutterBuildAction {
        @Override
        @NotNull
        protected BuildType buildType() {
            BuildType buildType = BuildType.APK;
            if (buildType == null) {
                APK.$$$reportNull$$$0(0);
            }
            return buildType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/actions/FlutterBuildActionGroup$APK", "buildType"));
        }
    }

    public static class AAR
    extends FlutterBuildAction {
        @Override
        @NotNull
        protected BuildType buildType() {
            BuildType buildType = BuildType.AAR;
            if (buildType == null) {
                AAR.$$$reportNull$$$0(0);
            }
            return buildType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/actions/FlutterBuildActionGroup$AAR", "buildType"));
        }
    }

    public static abstract class FlutterBuildAction
    extends AnAction {
        @NotNull
        protected abstract BuildType buildType();

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                FlutterBuildAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = event.getPresentation();
            Project project = event.getProject();
            if (project == null) {
                return;
            }
            FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
            if (sdk == null) {
                return;
            }
            PubRoot pubRoot = PubRoot.forEventWithRefresh(event);
            BuildType buildType = this.buildType();
            if (pubRoot != null) {
                FlutterBuildActionGroup.build(project, pubRoot, sdk, buildType, presentation.getDescription());
            } else {
                List<PubRoot> roots = PubRoots.forProject(project);
                for (PubRoot sub : roots) {
                    FlutterBuildActionGroup.build(project, sub, sdk, buildType, presentation.getDescription());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/FlutterBuildActionGroup$FlutterBuildAction", "actionPerformed"));
        }
    }
}

