/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterSdkAction;
import io.flutter.bazel.Workspace;
import io.flutter.console.FlutterConsoles;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterSdk;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDoctorAction
extends FlutterSdkAction {
    private static final Logger LOG = Logger.getInstance(FlutterDoctorAction.class);

    public void startCommand(@NotNull Project project, @NotNull FlutterSdk sdk, @Nullable PubRoot root) {
        if (project == null) {
            FlutterDoctorAction.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            FlutterDoctorAction.$$$reportNull$$$0(1);
        }
        sdk.flutterDoctor().startInConsole(project);
    }

    @Override
    public void startCommand(@NotNull Project project, @NotNull FlutterSdk sdk, @Nullable PubRoot root, @NotNull DataContext context) {
        if (project == null) {
            FlutterDoctorAction.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            FlutterDoctorAction.$$$reportNull$$$0(3);
        }
        if (context == null) {
            FlutterDoctorAction.$$$reportNull$$$0(4);
        }
        this.startCommand(project, sdk, root);
    }

    @Override
    public void startCommandInBazelContext(@NotNull Project project, @NotNull Workspace workspace, @NotNull AnActionEvent event) {
        String doctorScript;
        if (project == null) {
            FlutterDoctorAction.$$$reportNull$$$0(5);
        }
        if (workspace == null) {
            FlutterDoctorAction.$$$reportNull$$$0(6);
        }
        if (event == null) {
            FlutterDoctorAction.$$$reportNull$$$0(7);
        }
        if ((doctorScript = workspace.getDoctorScript()) != null) {
            this.runWorkspaceFlutterDoctorScript(project, workspace.getRoot().getPath(), doctorScript);
        } else {
            FlutterUtils.warn(LOG, "No \"doctorScript\" script in the flutter.json file.");
        }
    }

    private void runWorkspaceFlutterDoctorScript(@NotNull Project project, @NotNull String workDir, @NotNull String doctorScript) {
        if (project == null) {
            FlutterDoctorAction.$$$reportNull$$$0(8);
        }
        if (workDir == null) {
            FlutterDoctorAction.$$$reportNull$$$0(9);
        }
        if (doctorScript == null) {
            FlutterDoctorAction.$$$reportNull$$$0(10);
        }
        GeneralCommandLine cmdLine = new GeneralCommandLine().withWorkDirectory(workDir);
        cmdLine.setCharset(StandardCharsets.UTF_8);
        cmdLine.setExePath(FileUtil.toSystemDependentName((String)doctorScript));
        try {
            ColoredProcessHandler handler = new ColoredProcessHandler(cmdLine);
            FlutterConsoles.displayProcessLater(handler, project, null, () -> ((ColoredProcessHandler)handler).startNotify());
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean enableActionInBazelContext() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doctorScript";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/FlutterDoctorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommand";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommandInBazelContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "runWorkspaceFlutterDoctorScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

