/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterUtils;
import io.flutter.actions.OpenInAndroidStudioAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterExternalIdeActionGroup
extends DefaultActionGroup {
    private static boolean isExternalIdeFile(AnActionEvent e) {
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null || !file.exists()) {
            return false;
        }
        Project project = e.getProject();
        assert (project != null);
        return FlutterExternalIdeActionGroup.isWithinAndroidDirectory(file, project) || FlutterExternalIdeActionGroup.isProjectDirectory(file, project) || FlutterExternalIdeActionGroup.isWithinIOsDirectory(file, project) || FlutterUtils.isXcodeProjectFileName(file.getName()) || OpenInAndroidStudioAction.isProjectFileName(file.getName());
    }

    public static boolean isAndroidDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            FlutterExternalIdeActionGroup.$$$reportNull$$$0(0);
        }
        return file.isDirectory() && (file.getName().equals("android") || file.getName().equals(".android"));
    }

    public static boolean isIOsDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            FlutterExternalIdeActionGroup.$$$reportNull$$$0(1);
        }
        return file.isDirectory() && (file.getName().equals("ios") || file.getName().equals(".ios"));
    }

    protected static boolean isWithinAndroidDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        VirtualFile baseDir;
        if (file == null) {
            FlutterExternalIdeActionGroup.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FlutterExternalIdeActionGroup.$$$reportNull$$$0(3);
        }
        if ((baseDir = project.getBaseDir()) == null) {
            return false;
        }
        for (VirtualFile candidate = file; candidate != null && !baseDir.equals(candidate); candidate = candidate.getParent()) {
            if (!FlutterExternalIdeActionGroup.isAndroidDirectory(candidate)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isWithinIOsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        VirtualFile baseDir;
        if (file == null) {
            FlutterExternalIdeActionGroup.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FlutterExternalIdeActionGroup.$$$reportNull$$$0(5);
        }
        if ((baseDir = project.getBaseDir()) == null) {
            return false;
        }
        for (VirtualFile candidate = file; candidate != null && !baseDir.equals(candidate); candidate = candidate.getParent()) {
            if (!FlutterExternalIdeActionGroup.isIOsDirectory(candidate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isProjectDirectory(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            FlutterExternalIdeActionGroup.$$$reportNull$$$0(6);
        }
        if (!file.isDirectory() || project == null) {
            return false;
        }
        VirtualFile baseDir = project.getBaseDir();
        return baseDir != null && baseDir.getPath().equals(file.getPath());
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        boolean enabled = FlutterExternalIdeActionGroup.isExternalIdeFile(event);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/FlutterExternalIdeActionGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAndroidDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isIOsDirectory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isWithinAndroidDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWithinIOsDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

