/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import io.flutter.actions.ProjectActions;
import io.flutter.utils.FlutterModuleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlutterRetargetAppAction
extends DumbAwareAction {
    public static final String RELOAD_DISPLAY_ID = "Flutter Commands";
    @NotNull
    private final String myActionId;
    @NotNull
    private final List<String> myPlaces;

    FlutterRetargetAppAction(@NotNull String actionId, @Nullable String text, @Nullable String description, String ... places) {
        if (actionId == null) {
            FlutterRetargetAppAction.$$$reportNull$$$0(0);
        }
        if (places == null) {
            FlutterRetargetAppAction.$$$reportNull$$$0(1);
        }
        super(text, description, null);
        this.myPlaces = new ArrayList<String>();
        this.myActionId = actionId;
        this.myPlaces.addAll(Arrays.asList(places));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FlutterRetargetAppAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(AnActionEvent e) {
        AnAction action = this.getAction(e.getProject());
        if (action != null) {
            action.actionPerformed(e);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null || !FlutterModuleUtils.hasFlutterModule(project) || !this.myPlaces.contains(e.getPlace())) {
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(false);
        AnAction action = this.getAction(project);
        if (action != null) {
            Presentation template = action.getTemplatePresentation();
            String text = template.getTextWithMnemonic();
            if (text != null) {
                presentation.setText(text, true);
            }
            action.update(e);
        }
    }

    private AnAction getAction(@Nullable Project project) {
        return project == null ? null : ProjectActions.getAction(project, this.myActionId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/actions/FlutterRetargetAppAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/actions/FlutterRetargetAppAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

