/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.bazel.Workspace;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlutterSdkAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(FlutterSdkAction.class);

    public void actionPerformed(@NotNull AnActionEvent event) {
        FlutterSdk sdk;
        Workspace workspace;
        if (event == null) {
            FlutterSdkAction.$$$reportNull$$$0(0);
        }
        Project project = DumbAwareAction.getEventProject((AnActionEvent)event);
        if (this.enableActionInBazelContext() && (workspace = FlutterModuleUtils.getFlutterBazelWorkspace(project)) != null) {
            FlutterInitializer.sendAnalyticsAction((AnAction)this);
            FileDocumentManager.getInstance().saveAllDocuments();
            this.startCommandInBazelContext(project, workspace, event);
            return;
        }
        FlutterSdk flutterSdk = sdk = project != null ? FlutterSdk.getFlutterSdk(project) : null;
        if (sdk == null) {
            FlutterSdkAction.showMissingSdkDialog(project);
            return;
        }
        FlutterInitializer.sendAnalyticsAction((AnAction)this);
        FileDocumentManager.getInstance().saveAllDocuments();
        PubRoot root = PubRoot.forEventWithRefresh(event);
        @NotNull DataContext context = event.getDataContext();
        if (root != null) {
            this.startCommand(project, sdk, root, context);
        } else {
            List<PubRoot> roots = PubRoots.forProject(project);
            for (PubRoot sub : roots) {
                this.startCommand(project, sdk, sub, context);
            }
        }
    }

    public abstract void startCommand(@NotNull Project var1, @NotNull FlutterSdk var2, @Nullable PubRoot var3, @NotNull DataContext var4);

    public void startCommandInBazelContext(@NotNull Project project, @NotNull Workspace workspace, @NotNull AnActionEvent event) {
        if (project == null) {
            FlutterSdkAction.$$$reportNull$$$0(1);
        }
        if (workspace == null) {
            FlutterSdkAction.$$$reportNull$$$0(2);
        }
        if (event == null) {
            FlutterSdkAction.$$$reportNull$$$0(3);
        }
        throw new Error("This method should not be called directly, but should be overridden.");
    }

    public boolean enableActionInBazelContext() {
        return false;
    }

    public static void showMissingSdkDialog(Project project) {
        int response = FlutterMessages.showDialog(project, FlutterBundle.message("flutter.sdk.notAvailable.message", new Object[0]), FlutterBundle.message("flutter.sdk.notAvailable.title", new Object[0]), new String[]{"Yes, configure", "No, thanks"}, -1);
        if (response == 0) {
            FlutterUtils.openFlutterSettings(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/FlutterSdkAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommandInBazelContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

