/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterExternalIdeActionGroup;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInAndroidStudioAction
extends AnAction {
    private static final String LABEL_FILE = FlutterBundle.message("flutter.androidstudio.open.file.text", new Object[0]);
    private static final String DESCR_FILE = FlutterBundle.message("flutter.androidstudio.open.file.description", new Object[0]);
    private static final String LABEL_MODULE = FlutterBundle.message("flutter.androidstudio.open.module.text", new Object[0]);
    private static final String DESCR_MODULE = FlutterBundle.message("flutter.androidstudio.open.module.description", new Object[0]);
    private static final Logger LOG = Logger.getInstance(OpenInAndroidStudioAction.class);

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(0);
        }
        OpenInAndroidStudioAction.updatePresentation(event, event.getPresentation());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(1);
        }
        @Nullable Project project = event.getProject();
        if (FlutterUtils.isAndroidStudio()) {
            try {
                Class<?> opener = Class.forName("io.flutter.actions.OpenAndroidModule");
                ((OpenInAndroidStudioAction)((Object)opener.newInstance())).actionPerformed(event);
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Integer column;
            Integer line;
            String androidStudioPath = OpenInAndroidStudioAction.findAndroidStudio(project);
            if (androidStudioPath == null) {
                FlutterMessages.showError("Unable to locate Android Studio", "You can configure the Android Studio location via 'flutter config --android-studio-dir path-to-android-studio'.", project);
                return;
            }
            VirtualFile projectFile = OpenInAndroidStudioAction.findProjectFile(event);
            if (projectFile == null) {
                FlutterMessages.showError("Error Opening Android Studio", "Project not found.", project);
                return;
            }
            VirtualFile sourceFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
            String sourceFilePath = sourceFile == null ? null : (sourceFile.isDirectory() ? null : sourceFile.getPath());
            Editor editor = OpenInAndroidStudioAction.getCurrentEditor(project, sourceFile);
            if (editor != null) {
                CaretModel caretModel = editor.getCaretModel();
                line = caretModel.getLogicalPosition().line + 1;
                column = caretModel.getLogicalPosition().column;
            } else {
                column = null;
                line = null;
            }
            OpenInAndroidStudioAction.openFileInStudio(androidStudioPath, project, projectFile.getPath(), sourceFilePath, line, column);
        });
    }

    @Nullable
    private static Editor getCurrentEditor(@NotNull Project project, @Nullable VirtualFile file) {
        TextEditor textEditor;
        Editor editor;
        if (project == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            return null;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        if (fileEditor instanceof TextEditor && !(editor = (textEditor = (TextEditor)fileEditor).getEditor()).isDisposed()) {
            return editor;
        }
        return null;
    }

    private static void updatePresentation(AnActionEvent event, Presentation state) {
        if (OpenInAndroidStudioAction.findProjectFile(event) == null) {
            state.setVisible(false);
        } else {
            String descr;
            String label;
            VirtualFile file = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
            if (file != null && !file.isDirectory()) {
                label = LABEL_FILE;
                descr = DESCR_FILE;
            } else {
                label = LABEL_MODULE;
                descr = DESCR_MODULE;
            }
            state.setVisible(true);
            state.setText(label);
            state.setDescription(descr);
        }
    }

    protected static boolean isProjectFileName(String name) {
        return name.endsWith("_android.iml");
    }

    protected static VirtualFile findProjectFile(@Nullable AnActionEvent e) {
        if (e != null) {
            Project project;
            VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (file != null && file.exists()) {
                project = e.getProject();
                assert (project != null);
                if (FlutterExternalIdeActionGroup.isWithinIOsDirectory(file, project)) {
                    return null;
                }
                VirtualFile projectDir = project.getBaseDir();
                for (PubRoot root : PubRoots.forProject(project)) {
                    if (!root.isFlutterPlugin()) continue;
                    VirtualFile rootFile = root.getRoot();
                    VirtualFile aFile = file;
                    while (aFile != null) {
                        if (aFile.equals(rootFile)) {
                            for (VirtualFile child : rootFile.getChildren()) {
                                if (!OpenInAndroidStudioAction.isExampleWithAndroidWithApp(child)) continue;
                                return child.findChild("android");
                            }
                        }
                        if (aFile.equals(projectDir)) {
                            aFile = null;
                            continue;
                        }
                        aFile = aFile.getParent();
                    }
                }
                if (OpenInAndroidStudioAction.isProjectFileName(file.getName())) {
                    return OpenInAndroidStudioAction.getProjectForFile(file);
                }
            }
            if ((project = e.getProject()) != null) {
                return OpenInAndroidStudioAction.getProjectForFile(OpenInAndroidStudioAction.findStudioProjectFile(project));
            }
        }
        return null;
    }

    private static void openFileInStudio(@NotNull String androidStudioPath, final @NotNull Project project, final @NotNull String projectPath, @Nullable String sourceFile, @Nullable Integer line, @Nullable Integer column) {
        if (androidStudioPath == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(4);
        }
        if (projectPath == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(5);
        }
        try {
            GeneralCommandLine cmd;
            if (SystemInfo.isMac) {
                cmd = new GeneralCommandLine().withExePath("open").withParameters(new String[]{"-a", androidStudioPath, "--args", projectPath});
            } else {
                androidStudioPath = SystemInfo.isWindows ? (String)androidStudioPath + "\\bin\\studio.bat" : (String)androidStudioPath + "/bin/studio.sh";
                cmd = new GeneralCommandLine().withExePath((String)androidStudioPath).withParameters(new String[]{projectPath});
            }
            if (sourceFile != null) {
                if (line != null) {
                    cmd.addParameters(new String[]{"--line", line.toString()});
                    if (column != null) {
                        cmd.addParameters(new String[]{"--column", column.toString()});
                    }
                }
                cmd.addParameter(sourceFile);
            }
            ColoredProcessHandler handler = new ColoredProcessHandler(cmd);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        FlutterMessages.showError("Error Opening", projectPath, project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenInAndroidStudioAction$1", "processTerminated"));
                }
            });
            handler.startNotify();
        }
        catch (ExecutionException ex) {
            FlutterMessages.showError("Error Opening", "Exception: " + ex.getMessage(), project);
        }
    }

    @Nullable
    private static VirtualFile findStudioProjectFile(@NotNull Project project) {
        if (project == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(6);
        }
        for (PubRoot root : PubRoots.forProject(project)) {
            for (VirtualFile child : root.getRoot().getChildren()) {
                if (OpenInAndroidStudioAction.isProjectFileName(child.getName())) {
                    return child;
                }
                if (!FlutterExternalIdeActionGroup.isAndroidDirectory(child)) continue;
                for (VirtualFile androidChild : child.getChildren()) {
                    if (!OpenInAndroidStudioAction.isProjectFileName(androidChild.getName())) continue;
                    return androidChild;
                }
            }
        }
        return null;
    }

    @Nullable
    private static String findAndroidStudio(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk != null) {
            String androidSdkLocation = flutterSdk.queryFlutterConfig("android-studio-dir", true);
            if (androidSdkLocation != null && !new File(androidSdkLocation).exists()) {
                androidSdkLocation = flutterSdk.queryFlutterConfig("android-studio-dir", false);
            }
            if (androidSdkLocation != null) {
                if (androidSdkLocation.contains("/Android Studio 2.")) {
                    Messages.showErrorDialog((String)FlutterBundle.message("old.android.studio.message", File.separator), (String)FlutterBundle.message("old.android.studio.title", new Object[0]));
                    return null;
                }
                if (androidSdkLocation.endsWith("/")) {
                    androidSdkLocation = androidSdkLocation.substring(0, androidSdkLocation.length() - 1);
                }
                String contents = "/Contents";
                if (SystemInfo.isMac && androidSdkLocation.endsWith("/Contents")) {
                    return androidSdkLocation.substring(0, androidSdkLocation.length() - "/Contents".length());
                }
                return androidSdkLocation;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile getProjectForFile(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            return OpenInAndroidStudioAction.isAndroidWithApp(file) ? file : null;
        }
        VirtualFile dir = file.getParent();
        if (OpenInAndroidStudioAction.isAndroidWithApp(dir)) {
            return dir;
        }
        VirtualFile project = dir.findChild("android");
        if (project != null && OpenInAndroidStudioAction.isAndroidWithApp(project)) {
            return project;
        }
        project = dir.findChild(".android");
        if (project != null && OpenInAndroidStudioAction.isAndroidWithApp(project)) {
            return project;
        }
        return null;
    }

    private static boolean isAndroidWithApp(@NotNull VirtualFile file) {
        if (file == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(7);
        }
        return FlutterExternalIdeActionGroup.isAndroidDirectory(file) && (file.findChild("app") != null || file.findChild("src") != null);
    }

    private static boolean isExampleWithAndroidWithApp(@NotNull VirtualFile file) {
        if (file == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(8);
        }
        boolean hasPubspec = false;
        boolean hasAndroid = false;
        for (VirtualFile candidate : file.getChildren()) {
            if (OpenInAndroidStudioAction.isAndroidWithApp(candidate)) {
                hasAndroid = true;
            }
            if (candidate.getName().equals("pubspec.yaml")) {
                hasPubspec = true;
            }
            if (!hasAndroid || !hasPubspec) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidStudioPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/OpenInAndroidStudioAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentEditor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "openFileInStudio";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findStudioProjectFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAndroidWithApp";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isExampleWithAndroidWithApp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

