/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterMessages;
import io.flutter.actions.FlutterSdkAction;
import io.flutter.actions.OpenInXcodeAction;
import io.flutter.sdk.FlutterSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInAppCodeAction
extends AnAction {
    private static boolean IS_INITIALIZED = false;
    private static boolean IS_APPCODE_INSTALLED = false;

    private static void initialize() {
        if (SystemInfo.isMac) {
            try {
                GeneralCommandLine cmd = new GeneralCommandLine().withExePath("/bin/bash").withParameters(new String[]{"-c", "mdfind \"kMDItemContentType == 'com.apple.application-bundle'\" | grep AppCode.app"});
                ColoredProcessHandler handler = new ColoredProcessHandler(cmd);
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            IS_APPCODE_INSTALLED = true;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "io/flutter/actions/OpenInAppCodeAction$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                handler.startNotify();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        IS_INITIALIZED = true;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenInAppCodeAction.$$$reportNull$$$0(0);
        }
        if (!(SystemInfo.isMac && IS_INITIALIZED && IS_APPCODE_INSTALLED)) {
            event.getPresentation().setVisible(false);
        } else {
            Presentation presentation = event.getPresentation();
            boolean enabled = OpenInXcodeAction.findProjectFile(event) != null;
            presentation.setEnabledAndVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        VirtualFile projectFile;
        if (event == null) {
            OpenInAppCodeAction.$$$reportNull$$$0(1);
        }
        if ((projectFile = OpenInXcodeAction.findProjectFile(event)) != null) {
            OpenInAppCodeAction.openFile(projectFile);
        } else {
            @Nullable Project project = event.getProject();
            FlutterMessages.showError("Error Opening AppCode", "Project not found.", project);
        }
    }

    private static void openFile(@NotNull VirtualFile file) {
        Project project;
        FlutterSdk sdk;
        if (file == null) {
            OpenInAppCodeAction.$$$reportNull$$$0(2);
        }
        FlutterSdk flutterSdk = sdk = (project = ProjectUtil.guessProjectForFile((VirtualFile)file)) != null ? FlutterSdk.getFlutterSdk(project) : null;
        if (sdk == null) {
            FlutterSdkAction.showMissingSdkDialog(project);
            return;
        }
        OpenInAppCodeAction.openInAppCode(project, file.getParent().getPath());
    }

    private static void openInAppCode(final @Nullable Project project, final @NotNull String path) {
        if (path == null) {
            OpenInAppCodeAction.$$$reportNull$$$0(3);
        }
        try {
            GeneralCommandLine cmd = new GeneralCommandLine().withExePath("open").withParameters(new String[]{"-a", "AppCode.app", path});
            ColoredProcessHandler handler = new ColoredProcessHandler(cmd);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        FlutterMessages.showError("Error Opening", path, project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenInAppCodeAction$2", "processTerminated"));
                }
            });
            handler.startNotify();
        }
        catch (ExecutionException ex) {
            FlutterMessages.showError("Error Opening", "Exception: " + ex.getMessage(), project);
        }
    }

    static {
        OpenInAppCodeAction.initialize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/OpenInAppCodeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "openInAppCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

