/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterExternalIdeActionGroup;
import io.flutter.actions.FlutterSdkAction;
import io.flutter.actions.OpenInAndroidStudioAction;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.ProgressHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInXcodeAction
extends AnAction {
    @Nullable
    static VirtualFile findProjectFile(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenInXcodeAction.$$$reportNull$$$0(0);
        }
        VirtualFile file = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        Project project = event.getProject();
        if (file != null && file.exists()) {
            if (FlutterUtils.isXcodeFileName(file.getName())) {
                return file;
            }
            if (project == null) {
                return null;
            }
            if (FlutterExternalIdeActionGroup.isWithinAndroidDirectory(file, project) || OpenInAndroidStudioAction.isProjectFileName(file.getName())) {
                return null;
            }
        }
        if (project != null) {
            return FlutterModuleUtils.findXcodeProjectFile(project, file);
        }
        return null;
    }

    private static void openFile(final @NotNull VirtualFile file) {
        Project project;
        FlutterSdk sdk;
        if (file == null) {
            OpenInXcodeAction.$$$reportNull$$$0(1);
        }
        FlutterSdk flutterSdk = sdk = (project = ProjectUtil.guessProjectForFile((VirtualFile)file)) != null ? FlutterSdk.getFlutterSdk(project) : null;
        if (sdk == null) {
            FlutterSdkAction.showMissingSdkDialog(project);
            return;
        }
        PubRoot pubRoot = PubRoot.forFile(file);
        if (pubRoot == null) {
            FlutterMessages.showError("Error Opening Xcode", "Unable to run `flutter build` (no pub root found)", project);
            return;
        }
        if (!OpenInXcodeAction.hasBeenBuilt(pubRoot, sdk)) {
            ColoredProcessHandler processHandler;
            final ProgressHelper progressHelper = new ProgressHelper(project);
            progressHelper.start("Building for iOS");
            String buildArg = "--config-only";
            if (!sdk.getVersion().isXcodeConfigOnlySupported()) {
                buildArg = "--simulator";
            }
            if ((processHandler = sdk.flutterBuild(pubRoot, "ios", buildArg).startInConsole(project)) == null) {
                progressHelper.done();
                FlutterMessages.showError("Error Opening Xcode", "unable to run `flutter build`", project);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        progressHelper.done();
                        int exitCode = event.getExitCode();
                        if (exitCode != 0) {
                            FlutterMessages.showError("Error Opening Xcode", "`flutter build` returned: " + exitCode, project);
                            return;
                        }
                        OpenInXcodeAction.openWithXcode(project, file.getPath());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenInXcodeAction$1", "processTerminated"));
                    }
                });
            }
        } else {
            OpenInXcodeAction.openWithXcode(project, file.getPath());
        }
    }

    private static boolean hasBeenBuilt(@NotNull PubRoot pubRoot, @NotNull FlutterSdk sdk) {
        if (pubRoot == null) {
            OpenInXcodeAction.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            OpenInXcodeAction.$$$reportNull$$$0(3);
        }
        if (sdk.getVersion().isXcodeConfigOnlySupported()) {
            VirtualFile ios = pubRoot.getRoot().findChild("ios");
            if (ios == null || !ios.isDirectory()) {
                return false;
            }
            VirtualFile flutter = ios.findChild("Flutter");
            if (flutter == null || !flutter.isDirectory()) {
                return false;
            }
            VirtualFile gen = flutter.findChild("Generated.xcconfig");
            if (gen == null || gen.isDirectory()) {
                return false;
            }
            return sdk.isOlderThanToolsStamp(gen);
        }
        VirtualFile buildDir = pubRoot.getRoot().findChild("build");
        return buildDir != null && buildDir.isDirectory() && buildDir.findChild("ios") != null;
    }

    private static void openWithXcode(final @Nullable Project project, final String path) {
        try {
            GeneralCommandLine cmd = new GeneralCommandLine().withExePath("open").withParameters(new String[]{path});
            ColoredProcessHandler handler = new ColoredProcessHandler(cmd);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        FlutterMessages.showError("Error Opening", path, project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenInXcodeAction$2", "processTerminated"));
                }
            });
            handler.startNotify();
        }
        catch (ExecutionException ex) {
            FlutterMessages.showError("Error Opening", "Exception: " + ex.getMessage(), project);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenInXcodeAction.$$$reportNull$$$0(4);
        }
        if (!SystemInfo.isMac) {
            event.getPresentation().setVisible(false);
        } else {
            Presentation presentation = event.getPresentation();
            boolean enabled = OpenInXcodeAction.findProjectFile(event) != null;
            presentation.setEnabledAndVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        VirtualFile projectFile;
        if (event == null) {
            OpenInXcodeAction.$$$reportNull$$$0(5);
        }
        if ((projectFile = OpenInXcodeAction.findProjectFile(event)) != null) {
            OpenInXcodeAction.openFile(projectFile);
        } else {
            @Nullable Project project = event.getProject();
            FlutterMessages.showError("Error Opening Xcode", "Project not found.", project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/OpenInXcodeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findProjectFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasBeenBuilt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

