/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.analytics;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.QueueProcessor;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.analytics.ThrottlingBucket;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkVersion;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Analytics {
    public static final String GROUP_DISPLAY_ID = "Flutter Usage Statistics";
    public static final String TIMING_COMPLETE = "timing_complete";
    private static final String analyticsUrl = "https://www.google-analytics.com/collect";
    private static final String applicationName = "Flutter IntelliJ Plugin";
    private static final String trackingId = "UA-67589403-7";
    private static final int maxExceptionLength = 512;
    @NotNull
    private final String clientId;
    @NotNull
    private final String pluginVersion;
    @NotNull
    private final String platformName;
    @NotNull
    private final String platformVersion;
    @NotNull
    private Transport transport;
    @NotNull
    private ThrottlingBucket bucket;
    private boolean myCanSend;

    public Analytics(@NotNull String clientId, @NotNull String pluginVersion, @NotNull String platformName, @NotNull String platformVersion) {
        if (clientId == null) {
            Analytics.$$$reportNull$$$0(0);
        }
        if (pluginVersion == null) {
            Analytics.$$$reportNull$$$0(1);
        }
        if (platformName == null) {
            Analytics.$$$reportNull$$$0(2);
        }
        if (platformVersion == null) {
            Analytics.$$$reportNull$$$0(3);
        }
        this.transport = new HttpTransport();
        this.bucket = new ThrottlingBucket(20);
        this.myCanSend = false;
        this.clientId = clientId;
        this.pluginVersion = pluginVersion;
        this.platformName = platformName;
        this.platformVersion = platformVersion;
    }

    public void disableThrottling(@NotNull Runnable func) {
        if (func == null) {
            Analytics.$$$reportNull$$$0(4);
        }
        ThrottlingBucket original = this.bucket;
        try {
            this.bucket = new ThrottlingBucket.NonTrhottlingBucket(0);
            func.run();
        }
        finally {
            this.bucket = original;
        }
    }

    @NotNull
    public String getClientId() {
        String string = this.clientId;
        if (string == null) {
            Analytics.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean canSend() {
        return this.myCanSend;
    }

    public void setCanSend(boolean value) {
        this.myCanSend = value;
    }

    public void setTransport(@NotNull Transport transport) {
        if (transport == null) {
            Analytics.$$$reportNull$$$0(6);
        }
        this.transport = transport;
    }

    public void sendScreenView(@NotNull String viewName) {
        if (viewName == null) {
            Analytics.$$$reportNull$$$0(7);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("cd", viewName);
        this.sendPayload("screenview", args, null);
    }

    public void sendEvent(@NotNull String category, @NotNull String action) {
        if (category == null) {
            Analytics.$$$reportNull$$$0(8);
        }
        if (action == null) {
            Analytics.$$$reportNull$$$0(9);
        }
        this.sendEvent(category, action, null);
    }

    public void sendEvent(@NotNull String category, @NotNull String action, @Nullable FlutterSdk flutterSdk) {
        if (category == null) {
            Analytics.$$$reportNull$$$0(10);
        }
        if (action == null) {
            Analytics.$$$reportNull$$$0(11);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("ec", category);
        args.put("ea", action);
        this.sendPayload("event", args, flutterSdk);
    }

    public void sendEventWithSdk(@NotNull String category, @NotNull String action, @NotNull String sdkVersion) {
        if (category == null) {
            Analytics.$$$reportNull$$$0(12);
        }
        if (action == null) {
            Analytics.$$$reportNull$$$0(13);
        }
        if (sdkVersion == null) {
            Analytics.$$$reportNull$$$0(14);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("ec", category);
        args.put("ea", action);
        this.sendPayload("event", args, null, sdkVersion);
    }

    public void sendEventMetric(@NotNull String category, @NotNull String action, int value) {
        if (category == null) {
            Analytics.$$$reportNull$$$0(15);
        }
        if (action == null) {
            Analytics.$$$reportNull$$$0(16);
        }
        this.sendEventMetric(category, action, value, null);
    }

    public void sendEventMetric(@NotNull String category, @NotNull String action, int value, @Nullable FlutterSdk flutterSdk) {
        if (category == null) {
            Analytics.$$$reportNull$$$0(17);
        }
        if (action == null) {
            Analytics.$$$reportNull$$$0(18);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("ec", category);
        args.put("ea", action);
        args.put("ev", Integer.toString(value));
        this.sendPayload("event", args, flutterSdk);
    }

    public void sendEvent(@NotNull String category, @NotNull String action, @NotNull String label, @NotNull String value) {
        if (category == null) {
            Analytics.$$$reportNull$$$0(19);
        }
        if (action == null) {
            Analytics.$$$reportNull$$$0(20);
        }
        if (label == null) {
            Analytics.$$$reportNull$$$0(21);
        }
        if (value == null) {
            Analytics.$$$reportNull$$$0(22);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("ec", category);
        args.put("ea", action);
        if (!label.isEmpty()) {
            args.put("el", label);
        }
        args.put("ev", value);
        this.sendPayload("event", args, null);
    }

    public void sendTiming(@NotNull String category, @NotNull String variable, long timeMillis) {
        if (category == null) {
            Analytics.$$$reportNull$$$0(23);
        }
        if (variable == null) {
            Analytics.$$$reportNull$$$0(24);
        }
        this.sendEvent(category, TIMING_COMPLETE, variable, Long.toString(timeMillis));
    }

    public void sendExpectedException(@NotNull String location, @NotNull Throwable throwable) {
        if (location == null) {
            Analytics.$$$reportNull$$$0(25);
        }
        if (throwable == null) {
            Analytics.$$$reportNull$$$0(26);
        }
        this.sendEvent("expected-exception", location + ":" + throwable.getClass().getName());
    }

    public void sendException(@NotNull String throwableText, boolean isFatal) {
        if (throwableText == null) {
            Analytics.$$$reportNull$$$0(27);
        }
        String description = throwableText;
        description = description.replaceAll("com.intellij.openapi.", "c.i.o.");
        if ((description = description.replaceAll("com.intellij.", "c.i.")).length() > 512) {
            description = description.substring(0, 512);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("exd", description);
        if (isFatal) {
            args.put("'exf'", "1");
        }
        this.sendPayload("exception", args, null);
    }

    private void sendPayload(@NotNull String hitType, @NotNull Map<String, String> args, @Nullable FlutterSdk flutterSdk) {
        if (hitType == null) {
            Analytics.$$$reportNull$$$0(28);
        }
        if (args == null) {
            Analytics.$$$reportNull$$$0(29);
        }
        this.sendPayload(hitType, args, flutterSdk, null);
    }

    private void sendPayload(@NotNull String hitType, @NotNull Map<String, String> args, @Nullable FlutterSdk flutterSdk, @Nullable String sdkVersion) {
        if (hitType == null) {
            Analytics.$$$reportNull$$$0(30);
        }
        if (args == null) {
            Analytics.$$$reportNull$$$0(31);
        }
        if (!this.canSend()) {
            return;
        }
        if (!this.bucket.removeDrop()) {
            return;
        }
        args.put("v", "1");
        args.put("ds", "app");
        args.put("an", applicationName);
        args.put("av", this.pluginVersion);
        args.put("aiid", this.platformName);
        args.put("cd1", this.platformVersion);
        if (flutterSdk != null) {
            FlutterSdkVersion flutterVersion = flutterSdk.getVersion();
            if (flutterVersion.getVersionText() != null) {
                args.put("cd2", flutterVersion.getVersionText());
            }
        } else if (sdkVersion != null) {
            args.put("cd2", sdkVersion);
        }
        if (this.anyProjectUsesBazel()) {
            args.put("cd3", "bazel");
        }
        args.put("tid", trackingId);
        args.put("cid", this.clientId);
        args.put("t", hitType);
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            args.put("sr", screenSize.width + "x" + screenSize.height);
        }
        catch (HeadlessException screenSize) {
            // empty catch block
        }
        String language = System.getProperty("user.language");
        if (language != null) {
            args.put("ul", language);
        }
        this.transport.send(analyticsUrl, args);
    }

    private boolean anyProjectUsesBazel() {
        if (ApplicationManager.getApplication() == null) {
            return false;
        }
        ProjectManager mgr = ProjectManager.getInstance();
        if (mgr == null) {
            return false;
        }
        for (Project project : mgr.getOpenProjects()) {
            if (project.isDisposed() || DartSdk.getDartSdk((Project)project) == null || !WorkspaceCache.getInstance(project).isBazel()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/analytics/Analytics";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transport";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewName";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwableText";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hitType";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/analytics/Analytics";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disableThrottling";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTransport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendScreenView";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sendEvent";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sendEventWithSdk";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sendEventMetric";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sendTiming";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sendExpectedException";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sendException";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sendPayload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class HttpTransport
    implements Transport {
        private final QueueProcessor<Runnable> sendingQueue = QueueProcessor.createRunnableQueueProcessor();

        private HttpTransport() {
        }

        @Nullable
        private static String createUserAgent() {
            String locale = Locale.getDefault().toString();
            if (SystemInfo.isWindows) {
                return "Mozilla/5.0 (Windows; Windows; Windows; " + locale + ")";
            }
            if (SystemInfo.isMac) {
                return "Mozilla/5.0 (Macintosh; Intel Mac OS X; Macintosh; " + locale + ")";
            }
            if (SystemInfo.isLinux) {
                return "Mozilla/5.0 (Linux; Linux; Linux; " + locale + ")";
            }
            return null;
        }

        @Override
        public void send(@NotNull String url, @NotNull Map<String, String> values) {
            if (url == null) {
                HttpTransport.$$$reportNull$$$0(0);
            }
            if (values == null) {
                HttpTransport.$$$reportNull$$$0(1);
            }
            this.sendingQueue.add(() -> {
                try {
                    byte[] postDataBytes = this.createPostData(values);
                    HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                    String userAgent = HttpTransport.createUserAgent();
                    if (userAgent != null) {
                        conn.setRequestProperty("User-Agent", userAgent);
                    }
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(postDataBytes);
                    InputStream in = conn.getInputStream();
                    in.read();
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }

        byte[] createPostData(@NotNull Map<String, String> values) throws UnsupportedEncodingException {
            if (values == null) {
                HttpTransport.$$$reportNull$$$0(2);
            }
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, String> param : values.entrySet()) {
                if (!postData.isEmpty()) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), StandardCharsets.UTF_8));
                postData.append('=');
                postData.append(URLEncoder.encode(param.getValue(), StandardCharsets.UTF_8));
            }
            return postData.toString().getBytes(StandardCharsets.UTF_8);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/analytics/Analytics$HttpTransport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "send";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPostData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Transport {
        public void send(@NotNull String var1, @NotNull Map<String, String> var2);
    }

    private static class NonTransport
    extends HttpTransport {
        private static final Logger LOG = Logger.getInstance(Analytics.class);

        private NonTransport() {
        }

        @Override
        public void send(@NotNull String url, @NotNull Map<String, String> values) {
            if (url == null) {
                NonTransport.$$$reportNull$$$0(0);
            }
            if (values == null) {
                NonTransport.$$$reportNull$$$0(1);
            }
            try {
                byte[] postDataBytes = this.createPostData(values);
                LOG.info("Sending " + postDataBytes.length + " bytes " + new String(postDataBytes));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "values";
                    break;
                }
            }
            objectArray[1] = "io/flutter/analytics/Analytics$NonTransport";
            objectArray[2] = "send";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

