/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.analytics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.ide.completion.DartCompletionTimerExtension;
import io.flutter.analytics.FlutterAnalysisServerListener;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCompletionTimerListener
extends DartCompletionTimerExtension {
    @Nullable
    FlutterAnalysisServerListener dasListener;
    @Nullable
    Long startTimeMS;

    public void dartCompletionStart() {
        if (this.dasListener == null) {
            try {
                Project project = ProjectManager.getInstance().getDefaultProject();
                this.dasListener = FlutterAnalysisServerListener.getInstance(project);
            }
            catch (IncorrectOperationException ex) {
                return;
            }
        }
        this.startTimeMS = Instant.now().toEpochMilli();
    }

    public void dartCompletionEnd() {
        if (this.dasListener != null && this.startTimeMS != null) {
            long durationTimeMS = Instant.now().toEpochMilli() - this.startTimeMS;
            this.dasListener.logE2ECompletionSuccessMS(durationTimeMS);
            this.startTimeMS = null;
        }
    }

    public void dartCompletionError(@NotNull String code, @NotNull String message, @NotNull String stackTrace) {
        if (code == null) {
            DartCompletionTimerListener.$$$reportNull$$$0(0);
        }
        if (message == null) {
            DartCompletionTimerListener.$$$reportNull$$$0(1);
        }
        if (stackTrace == null) {
            DartCompletionTimerListener.$$$reportNull$$$0(2);
        }
        if (this.dasListener != null && this.startTimeMS != null) {
            long durationTimeMS = Instant.now().toEpochMilli() - this.startTimeMS;
            this.dasListener.logE2ECompletionErrorMS(durationTimeMS);
            this.startTimeMS = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "code";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "stackTrace";
                break;
            }
        }
        objectArray[1] = "io/flutter/analytics/DartCompletionTimerListener";
        objectArray[2] = "dartCompletionError";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

