/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.analytics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.RequestListener;
import com.google.dart.server.ResponseListener;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.fixes.DartQuickFix;
import com.jetbrains.lang.dart.fixes.DartQuickFixListener;
import io.flutter.FlutterInitializer;
import io.flutter.analytics.Analytics;
import io.flutter.analytics.RequestDetails;
import io.flutter.utils.FileUtils;
import java.beans.PropertyChangeEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.AnalysisStatus;
import org.dartlang.analysis.server.protocol.AvailableSuggestionSet;
import org.dartlang.analysis.server.protocol.ClosingLabel;
import org.dartlang.analysis.server.protocol.CompletionSuggestion;
import org.dartlang.analysis.server.protocol.HighlightRegion;
import org.dartlang.analysis.server.protocol.ImplementedClass;
import org.dartlang.analysis.server.protocol.ImplementedMember;
import org.dartlang.analysis.server.protocol.IncludedSuggestionRelevanceTag;
import org.dartlang.analysis.server.protocol.IncludedSuggestionSet;
import org.dartlang.analysis.server.protocol.NavigationRegion;
import org.dartlang.analysis.server.protocol.Occurrences;
import org.dartlang.analysis.server.protocol.Outline;
import org.dartlang.analysis.server.protocol.OverrideMember;
import org.dartlang.analysis.server.protocol.PubStatus;
import org.dartlang.analysis.server.protocol.RequestError;
import org.dartlang.analysis.server.protocol.SearchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class FlutterAnalysisServerListener
implements Disposable,
AnalysisServerListener {
    static final String INITIAL_COMPUTE_ERRORS_TIME = "initialComputeErrorsTime";
    static final String INITIAL_HIGHLIGHTS_TIME = "initialHighlightsTime";
    static final String INITIAL_OUTLINE_TIME = "initialOutlineTime";
    static final String ROUND_TRIP_TIME = "roundTripTime";
    static final String QUICK_FIX = "quickFix";
    static final String UNKNOWN_LOOKUP_STRING = "<unknown>";
    static final String ANALYSIS_SERVER_LOG = "analysisServerLog";
    static final String ACCEPTED_COMPLETION = "acceptedCompletion";
    static final String REJECTED_COMPLETION = "rejectedCompletion";
    static final String E2E_IJ_COMPLETION_TIME = "e2eIJCompletionTime";
    static final String GET_SUGGESTIONS = "completion.getSuggestions";
    static final String FIND_REFERENCES = "search.findElementReferences";
    static final Set<String> MANUALLY_MANAGED_METHODS = Sets.newHashSet((Object[])new String[]{"completion.getSuggestions", "search.findElementReferences"});
    static final String ERRORS = "errors";
    static final String WARNINGS = "warnings";
    static final String HINTS = "hints";
    static final String LINTS = "lints";
    static final String DURATION = "duration";
    static final String FAILURE = "failure";
    static final String SUCCESS = "success";
    static final String ERROR_TYPE_REQUEST = "R";
    static final String ERROR_TYPE_SERVER = "@";
    static final String DAS_STATUS_EVENT_TYPE = "analysisServerStatus";
    static final String[] ERROR_TYPES = new String[]{"CHECKED_MODE_COMPILE_TIME_ERROR", "COMPILE_TIME_ERROR", "HINT", "LINT", "STATIC_TYPE_WARNING", "STATIC_WARNING", "SYNTACTIC_ERROR"};
    static final String LOG_ENTRY_KIND = "kind";
    static final String LOG_ENTRY_TIME = "time";
    static final String LOG_ENTRY_DATA = "data";
    static final String LOG_ENTRY_SDK_VERSION = "sdkVersion";
    static final HashSet<String> REQUEST_ERRORS_TO_IGNORE = new HashSet();
    private static final long ERROR_REPORT_INTERVAL = 0x6DDD00L;
    private static final long GENERAL_REPORT_INTERVAL = 60000L;
    private static final Logger LOG;
    private static final boolean IS_TESTING;
    @NotNull
    final FlutterRequestListener requestListener;
    @NotNull
    final FlutterResponseListener responseListener;
    @NotNull
    final DartQuickFixListener quickFixListener;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, List<AnalysisError>> pathToErrors;
    @NotNull
    private final Map<String, Instant> pathToErrorTimestamps;
    @NotNull
    private final Map<String, Instant> pathToHighlightTimestamps;
    @NotNull
    private final Map<String, Instant> pathToOutlineTimestamps;
    @NotNull
    private final Map<String, RequestDetails> requestToDetails;
    @NotNull
    private final MessageBusConnection messageBusConnection;
    @NotNull
    private final FileEditorManagerListener fileEditorManagerListener;
    LookupSelectionHandler lookupSelectionHandler;
    @NotNull
    private Instant nextMemoryUsageLoggedInstant;
    private long errorsTimestamp;
    private long generalTimestamp;
    private int errorCount;
    private int warningCount;
    private int hintCount;
    private int lintCount;

    FlutterAnalysisServerListener(@NotNull Project project) {
        if (project == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(0);
        }
        this.nextMemoryUsageLoggedInstant = Instant.EPOCH;
        this.project = project;
        this.pathToErrors = new HashMap<String, List<AnalysisError>>();
        this.pathToErrorTimestamps = new HashMap<String, Instant>();
        this.pathToHighlightTimestamps = new HashMap<String, Instant>();
        this.pathToOutlineTimestamps = new HashMap<String, Instant>();
        this.requestToDetails = new HashMap<String, RequestDetails>();
        this.messageBusConnection = project.getMessageBus().connect();
        LookupManager.getInstance((Project)project).addPropertyChangeListener(this::onPropertyChange);
        this.fileEditorManagerListener = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                String filePath = file.getPath();
                Instant nowInstant = Instant.now();
                FlutterAnalysisServerListener.this.pathToErrorTimestamps.put(filePath, nowInstant);
                FlutterAnalysisServerListener.this.pathToHighlightTimestamps.put(filePath, nowInstant);
                FlutterAnalysisServerListener.this.pathToOutlineTimestamps.put(filePath, nowInstant);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(4);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/analytics/FlutterAnalysisServerListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.fileEditorManagerListener);
        this.messageBusConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                FlutterAnalysisServerListener.this.messageBusConnection.disconnect();
                FlutterAnalysisServerListener.this.errorsTimestamp = 0L;
                FlutterAnalysisServerListener.this.maybeReportErrorCounts();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/analytics/FlutterAnalysisServerListener$2", "projectClosing"));
            }
        });
        this.quickFixListener = new QuickFixListener();
        this.requestListener = new FlutterRequestListener();
        this.responseListener = new FlutterResponseListener();
        DartAnalysisServerService analysisServer = DartAnalysisServerService.getInstance((Project)project);
        analysisServer.addQuickFixListener(this.quickFixListener);
        analysisServer.addRequestListener((RequestListener)this.requestListener);
        analysisServer.addResponseListener((ResponseListener)this.responseListener);
    }

    @NotNull
    public static FlutterAnalysisServerListener getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(1);
        }
        FlutterAnalysisServerListener flutterAnalysisServerListener = Objects.requireNonNull((FlutterAnalysisServerListener)project.getService(FlutterAnalysisServerListener.class));
        if (flutterAnalysisServerListener == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(2);
        }
        return flutterAnalysisServerListener;
    }

    @NotNull
    private static String safelyGetString(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement;
        if (jsonObject != null && StringUtil.isNotEmpty((String)memberName) && (jsonElement = jsonObject.get(memberName)) != null) {
            String string = Objects.requireNonNull(jsonElement.getAsString());
            if (string == null) {
                FlutterAnalysisServerListener.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    public void dispose() {
        LookupManager.getInstance((Project)this.project).removePropertyChangeListener(this::onPropertyChange);
    }

    public void computedAnalyzedFiles(List<String> list) {
    }

    public void computedAvailableSuggestions(@NotNull List<AvailableSuggestionSet> list, int[] ints) {
        if (list == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(4);
        }
    }

    public void computedCompletion(String completionId, int replacementOffset, int replacementLength, List<CompletionSuggestion> completionSuggestions, List<IncludedSuggestionSet> includedSuggestionSets, List<String> includedElementKinds, List<IncludedSuggestionRelevanceTag> includedSuggestionRelevanceTags, boolean isLast, String libraryFilePathSD) {
        long currentTimestamp = System.currentTimeMillis();
        String id = this.getIdForMethod(GET_SUGGESTIONS);
        if (id == null) {
            return;
        }
        RequestDetails details = this.requestToDetails.remove(id);
        if (details == null) {
            return;
        }
        this.maybeReport(true, analytics -> {
            long startTime = details.startTime().toEpochMilli();
            analytics.sendTiming(ROUND_TRIP_TIME, GET_SUGGESTIONS, currentTimestamp - startTime);
        });
    }

    @Nullable
    private String getIdForMethod(@NotNull String method) {
        if (method == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(5);
        }
        Set<String> keys = this.requestToDetails.keySet();
        for (String id : keys) {
            RequestDetails details = this.requestToDetails.get(id);
            assert (details != null);
            if (!GET_SUGGESTIONS.equals(details.method())) continue;
            return id;
        }
        return null;
    }

    public void computedErrors(String path, List<AnalysisError> list) {
        assert (list != null);
        this.pathToErrors.put(path, list);
        assert (path != null);
        this.maybeLogInitialAnalysisTime(INITIAL_COMPUTE_ERRORS_TIME, path, this.pathToErrorTimestamps);
    }

    @NotNull
    public List<AnalysisError> getAnalysisErrorsForFile(String path) {
        if (path == null) {
            List list = AnalysisError.EMPTY_LIST;
            if (list == null) {
                FlutterAnalysisServerListener.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<AnalysisError> list = Objects.requireNonNull(this.pathToErrors.getOrDefault(path, AnalysisError.EMPTY_LIST));
        if (list == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private HashMap<String, Integer> getTotalAnalysisErrorCounts() {
        int[] errorCountsArray = new int[ERROR_TYPES.length];
        for (String keyPath : this.pathToErrors.keySet()) {
            assert (keyPath != null);
            List<AnalysisError> errors = this.getAnalysisErrorsForFile(keyPath);
            errors.removeIf(e -> {
                assert (e != null);
                return Objects.equals(e.getType(), "TODO");
            });
            if (errors.isEmpty()) continue;
            int i = 0;
            while (i < ERROR_TYPES.length) {
                int j;
                int n = j = i++;
                errorCountsArray[n] = errorCountsArray[n] + (int)errors.stream().filter(e -> {
                    assert (e != null);
                    return Objects.equals(e.getType(), ERROR_TYPES[j]);
                }).count();
            }
        }
        HashMap<String, Integer> errorCounts = new HashMap<String, Integer>();
        for (int i = 0; i < ERROR_TYPES.length; ++i) {
            errorCounts.put(ERROR_TYPES[i], errorCountsArray[i]);
        }
        HashMap<String, Integer> hashMap = errorCounts;
        if (hashMap == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    public void computedHighlights(String path, List<HighlightRegion> list) {
        assert (path != null);
        this.maybeLogInitialAnalysisTime(INITIAL_HIGHLIGHTS_TIME, path, this.pathToHighlightTimestamps);
    }

    public void computedImplemented(String s, List<ImplementedClass> list, List<ImplementedMember> list1) {
    }

    public void computedLaunchData(String s, String s1, String[] strings) {
    }

    public void computedNavigation(String s, List<NavigationRegion> list) {
    }

    public void computedOccurrences(String s, List<Occurrences> list) {
    }

    public void computedOutline(String path, Outline outline) {
        assert (path != null);
        this.maybeLogInitialAnalysisTime(INITIAL_OUTLINE_TIME, path, this.pathToOutlineTimestamps);
    }

    public void computedOverrides(String s, List<OverrideMember> list) {
    }

    public void computedClosingLabels(String s, List<ClosingLabel> list) {
    }

    public void computedSearchResults(String searchId, List<SearchResult> results, boolean isLast) {
        RequestDetails details = this.requestToDetails.remove(searchId);
        if (details == null) {
            return;
        }
        this.maybeReport(true, analytics -> {
            String method = details.method();
            long duration = this.generalTimestamp - details.startTime().toEpochMilli();
            LOG.debug("roundTripTime " + method + " " + duration);
            analytics.sendTiming(ROUND_TRIP_TIME, method, duration);
        });
    }

    public void flushedResults(List<String> list) {
    }

    public void requestError(RequestError requestError) {
        this.maybeReport(true, analytics -> {
            assert (requestError != null);
            String code = requestError.getCode();
            if (code == null) {
                code = requestError.getMessage();
            }
            if (REQUEST_ERRORS_TO_IGNORE.contains(code)) {
                return;
            }
            String stack = requestError.getStackTrace();
            String exception = FlutterAnalysisServerListener.composeException(ERROR_TYPE_REQUEST, code, stack);
            LOG.debug(exception);
            analytics.sendException(exception, false);
        });
    }

    private static String composeException(@NotNull String type, @Nullable String code, @Nullable String stack) {
        if (type == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(9);
        }
        Object exception = type + " ";
        if (code != null && !code.isEmpty()) {
            exception = (String)exception + code;
            if (stack != null && !stack.isEmpty()) {
                exception = (String)exception + "\n" + stack;
            }
        } else {
            exception = stack != null && !stack.isEmpty() ? (String)exception + stack : (String)exception + "exception";
        }
        if (((String)exception).length() > 150) {
            exception = ((String)exception).substring(0, 149);
        }
        return exception;
    }

    public void serverConnected(String s) {
    }

    public void serverError(boolean isFatal, String message, String stackTraceString) {
        this.maybeReport(true, analytics -> {
            String exception = FlutterAnalysisServerListener.composeException(ERROR_TYPE_SERVER, message, stackTraceString);
            LOG.debug(exception + " fatal");
            analytics.sendException(exception, isFatal);
        });
    }

    public void serverIncompatibleVersion(String s) {
    }

    public void serverStatus(AnalysisStatus analysisStatus, PubStatus pubStatus) {
        assert (analysisStatus != null);
        if (!analysisStatus.isAnalyzing()) {
            @NotNull HashMap<String, Integer> errorCounts = this.getTotalAnalysisErrorCounts();
            this.errorCount = 0;
            this.errorCount += FlutterAnalysisServerListener.extractCount(errorCounts, "CHECKED_MODE_COMPILE_TIME_ERROR");
            this.errorCount += FlutterAnalysisServerListener.extractCount(errorCounts, "COMPILE_TIME_ERROR");
            this.errorCount += FlutterAnalysisServerListener.extractCount(errorCounts, "SYNTACTIC_ERROR");
            this.warningCount = 0;
            this.warningCount += FlutterAnalysisServerListener.extractCount(errorCounts, "STATIC_TYPE_WARNING");
            this.warningCount += FlutterAnalysisServerListener.extractCount(errorCounts, "STATIC_WARNING");
            this.hintCount = FlutterAnalysisServerListener.extractCount(errorCounts, "HINT");
            this.lintCount = FlutterAnalysisServerListener.extractCount(errorCounts, "LINT");
            if (IS_TESTING) {
                this.lintCount = 1;
                this.hintCount = 1;
                this.warningCount = 1;
                this.errorCount = 1;
            }
            this.maybeReportErrorCounts();
        }
    }

    private void maybeReport(boolean observeThrottling, @NotNull @NotNull Consumer<@NotNull Analytics> func) {
        if (func == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(10);
        }
        long currentTimestamp = System.currentTimeMillis();
        if (observeThrottling && !IS_TESTING && currentTimestamp - this.generalTimestamp < 60000L) {
            return;
        }
        this.generalTimestamp = currentTimestamp;
        func.accept(FlutterInitializer.getAnalytics());
    }

    private void maybeReportErrorCounts() {
        long currentTimestamp = System.currentTimeMillis();
        if (this.errorsTimestamp == 0L || currentTimestamp - this.errorsTimestamp > 0x6DDD00L || IS_TESTING) {
            this.errorsTimestamp = currentTimestamp;
            Analytics analytics = FlutterInitializer.getAnalytics();
            LOG.debug("analysisServerStatus " + this.errorCount + " " + this.warningCount + " " + this.hintCount + " " + this.lintCount);
            analytics.disableThrottling(() -> {
                if (this.errorCount > 0) {
                    analytics.sendEventMetric(DAS_STATUS_EVENT_TYPE, ERRORS, this.errorCount);
                }
                if (this.warningCount > 0) {
                    analytics.sendEventMetric(DAS_STATUS_EVENT_TYPE, WARNINGS, this.warningCount);
                }
                if (this.hintCount > 0) {
                    analytics.sendEventMetric(DAS_STATUS_EVENT_TYPE, HINTS, this.hintCount);
                }
                if (this.lintCount > 0) {
                    analytics.sendEventMetric(DAS_STATUS_EVENT_TYPE, LINTS, this.lintCount);
                }
            });
            this.lintCount = 0;
            this.hintCount = 0;
            this.warningCount = 0;
            this.errorCount = 0;
        }
    }

    private static int extractCount(@NotNull Map<String, Integer> errorCounts, String name) {
        if (errorCounts == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(11);
        }
        return errorCounts.containsKey(name) ? errorCounts.get(name) : 0;
    }

    public void computedExistingImports(String file, Map<String, Map<String, Set<String>>> existingImports) {
    }

    private void logCompletion(@NotNull String selection, int prefixLength, @NotNull String eventType) {
        if (selection == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(12);
        }
        if (eventType == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(13);
        }
        this.maybeReport(true, analytics -> {
            LOG.debug(eventType + " " + selection + " " + prefixLength);
            analytics.sendEventMetric(eventType, selection, prefixLength);
        });
    }

    void logE2ECompletionSuccessMS(long e2eCompletionMS) {
        this.maybeReport(true, analytics -> {
            LOG.debug("e2eIJCompletionTime success " + e2eCompletionMS);
            analytics.sendTiming(E2E_IJ_COMPLETION_TIME, SUCCESS, e2eCompletionMS);
        });
    }

    void logE2ECompletionErrorMS(long e2eCompletionMS) {
        this.maybeReport(true, analytics -> {
            LOG.debug("e2eIJCompletionTime failure " + e2eCompletionMS);
            analytics.sendTiming(E2E_IJ_COMPLETION_TIME, FAILURE, e2eCompletionMS);
        });
    }

    private void maybeLogInitialAnalysisTime(@NotNull String eventType, @NotNull String path, @NotNull Map<String, Instant> pathToStartTime) {
        if (eventType == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(14);
        }
        if (path == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(15);
        }
        if (pathToStartTime == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(16);
        }
        if (!pathToStartTime.containsKey(path)) {
            return;
        }
        this.logFileAnalysisTime(eventType, path, Objects.requireNonNull(Duration.between(Objects.requireNonNull(pathToStartTime.get(path)), Instant.now())).toMillis());
        pathToStartTime.remove(path);
    }

    private void logFileAnalysisTime(@NotNull String kind, String path, long analysisTime) {
        if (kind == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(17);
        }
        this.maybeReport(false, analytics -> {
            LOG.debug(kind + " duration " + analysisTime);
            analytics.sendEvent(kind, DURATION, "", Long.toString(analysisTime));
        });
    }

    void onPropertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        Object newValue;
        if (propertyChangeEvent == null) {
            FlutterAnalysisServerListener.$$$reportNull$$$0(18);
        }
        if (!((newValue = propertyChangeEvent.getNewValue()) instanceof LookupImpl)) {
            return;
        }
        this.setLookupSelectionHandler();
        LookupImpl lookup = (LookupImpl)newValue;
        lookup.addLookupListener((LookupListener)this.lookupSelectionHandler);
    }

    @VisibleForTesting
    void setLookupSelectionHandler() {
        this.lookupSelectionHandler = new LookupSelectionHandler();
    }

    static {
        REQUEST_ERRORS_TO_IGNORE.addAll(Arrays.asList("FORMAT_WITH_ERRORS", "ORGANIZE_DIRECTIVES_ERROR", "REFACTORING_REQUEST_CANCELLED"));
        LOG = Logger.getInstance(FlutterAnalysisServerListener.class);
        IS_TESTING = ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/analytics/FlutterAnalysisServerListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCounts";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToStartTime";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = LOG_ENTRY_KIND;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyChangeEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/analytics/FlutterAnalysisServerListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "safelyGetString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisErrorsForFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalAnalysisErrorCounts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computedAvailableSuggestions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIdForMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "composeException";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "maybeReport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractCount";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logCompletion";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "maybeLogInitialAnalysisTime";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logFileAnalysisTime";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onPropertyChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private class QuickFixListener
    implements DartQuickFixListener {
        private QuickFixListener() {
        }

        public void beforeQuickFixInvoked(@NotNull DartQuickFix intention, @NotNull Editor editor, @NotNull PsiFile file) {
            if (intention == null) {
                QuickFixListener.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                QuickFixListener.$$$reportNull$$$0(1);
            }
            if (file == null) {
                QuickFixListener.$$$reportNull$$$0(2);
            }
            FlutterAnalysisServerListener.this.maybeReport(true, analytics -> {
                String path = Objects.requireNonNull(file.getVirtualFile()).getPath();
                int lineNumber = editor.getCaretModel().getLogicalPosition().line + 1;
                ImmutableList errorsOnLine = FlutterAnalysisServerListener.this.pathToErrors.containsKey(path) ? FlutterAnalysisServerListener.this.pathToErrors.get(path).stream().filter(error -> error.getLocation().getStartLine() == lineNumber).map(AnalysisError::getCode).collect(Collectors.toList()) : ImmutableList.of();
                LOG.debug("quickFix " + intention.getText() + " " + errorsOnLine.size());
                analytics.sendEventMetric(FlutterAnalysisServerListener.QUICK_FIX, intention.getText(), errorsOnLine.size());
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "intention";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "io/flutter/analytics/FlutterAnalysisServerListener$QuickFixListener";
            objectArray[2] = "beforeQuickFixInvoked";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class FlutterRequestListener
    implements RequestListener {
        FlutterRequestListener() {
        }

        public void onRequest(String jsonString) {
            JsonObject request = (JsonObject)new Gson().fromJson(jsonString, JsonObject.class);
            RequestDetails details = new RequestDetails(request.get("method").getAsString(), Instant.now());
            String id = Objects.requireNonNull(request.get("id")).getAsString();
            FlutterAnalysisServerListener.this.requestToDetails.put(id, details);
        }
    }

    class FlutterResponseListener
    implements ResponseListener {
        final Map<String, Long> methodTimestamps = new HashMap<String, Long>();

        FlutterResponseListener() {
        }

        public void onResponse(String jsonString) {
            JsonObject serverLogEntry;
            JsonObject response = (JsonObject)new Gson().fromJson(jsonString, JsonObject.class);
            if (response == null) {
                return;
            }
            if (FlutterAnalysisServerListener.safelyGetString(response, "event").equals("server.log") && (serverLogEntry = Objects.requireNonNull(response.getAsJsonObject("params")).getAsJsonObject("entry")) != null) {
                FlutterAnalysisServerListener.this.maybeReport(true, analytics -> {
                    String sdkVersionValue = FlutterAnalysisServerListener.safelyGetString(serverLogEntry, FlutterAnalysisServerListener.LOG_ENTRY_SDK_VERSION);
                    String logEntry = String.format("%s|%s|%s|%s|%s|%s", FlutterAnalysisServerListener.LOG_ENTRY_TIME, serverLogEntry.get(FlutterAnalysisServerListener.LOG_ENTRY_TIME).getAsInt(), FlutterAnalysisServerListener.LOG_ENTRY_KIND, serverLogEntry.get(FlutterAnalysisServerListener.LOG_ENTRY_KIND).getAsString(), FlutterAnalysisServerListener.LOG_ENTRY_DATA, serverLogEntry.get(FlutterAnalysisServerListener.LOG_ENTRY_DATA).getAsString());
                    assert (logEntry != null);
                    LOG.debug("analysisServerLog " + logEntry);
                    if (StringUtil.isEmpty((String)sdkVersionValue)) {
                        analytics.sendEvent(FlutterAnalysisServerListener.ANALYSIS_SERVER_LOG, logEntry);
                    } else {
                        analytics.sendEventWithSdk(FlutterAnalysisServerListener.ANALYSIS_SERVER_LOG, logEntry, sdkVersionValue);
                    }
                });
            }
            if (response.get("id") == null) {
                return;
            }
            String id = response.get("id").getAsString();
            RequestDetails details = FlutterAnalysisServerListener.this.requestToDetails.get(id);
            if (details != null) {
                if (MANUALLY_MANAGED_METHODS.contains(details.method())) {
                    return;
                }
                Long timestamp = this.methodTimestamps.get(details.method());
                long currentTimestamp = System.currentTimeMillis();
                if (timestamp == null || currentTimestamp - timestamp > 60000L) {
                    this.methodTimestamps.put(details.method(), currentTimestamp);
                    LOG.debug("roundTripTime " + details.method() + " " + Duration.between(details.startTime(), Instant.now()).toMillis());
                    FlutterInitializer.getAnalytics().sendTiming(FlutterAnalysisServerListener.ROUND_TRIP_TIME, details.method(), Objects.requireNonNull(Duration.between(details.startTime(), Instant.now())).toMillis());
                }
            }
            FlutterAnalysisServerListener.this.requestToDetails.remove(id);
        }
    }

    class LookupSelectionHandler
    implements LookupListener {
        LookupSelectionHandler() {
        }

        public void lookupCanceled(@NotNull LookupEvent event) {
            if (event == null) {
                LookupSelectionHandler.$$$reportNull$$$0(0);
            }
            if (event.isCanceledExplicitly() && this.isDartLookupEvent(event)) {
                FlutterAnalysisServerListener.this.logCompletion(FlutterAnalysisServerListener.UNKNOWN_LOOKUP_STRING, -1, FlutterAnalysisServerListener.REJECTED_COMPLETION);
            }
        }

        public void itemSelected(@NotNull LookupEvent event) {
            if (event == null) {
                LookupSelectionHandler.$$$reportNull$$$0(1);
            }
            if (event.getItem() == null) {
                return;
            }
            String selection = event.getItem().getLookupString();
            LookupImpl lookup = (LookupImpl)event.getLookup();
            assert (lookup != null);
            int prefixLength = lookup.getPrefixLength(event.getItem());
            if (this.isDartLookupEvent(event)) {
                FlutterAnalysisServerListener.this.logCompletion(selection, prefixLength, FlutterAnalysisServerListener.ACCEPTED_COMPLETION);
            }
        }

        public void currentItemChanged(@NotNull LookupEvent event) {
            if (event == null) {
                LookupSelectionHandler.$$$reportNull$$$0(2);
            }
        }

        private boolean isDartLookupEvent(@NotNull LookupEvent event) {
            LookupImpl lookup;
            if (event == null) {
                LookupSelectionHandler.$$$reportNull$$$0(3);
            }
            return (lookup = (LookupImpl)event.getLookup()) != null && lookup.getPsiFile() != null && lookup.getPsiFile().getVirtualFile() != null && FileUtils.isDartFile(Objects.requireNonNull(lookup.getPsiFile().getVirtualFile()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "io/flutter/analytics/FlutterAnalysisServerListener$LookupSelectionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lookupCanceled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "currentItemChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDartLookupEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

