/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.analytics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import io.flutter.analytics.Analytics;
import org.jetbrains.annotations.NotNull;

public class ToolWindowTracker
implements ToolWindowManagerListener {
    private final Analytics myAnalytics;
    private final ToolWindowManagerEx myToolWindowManager;
    private String currentWindowId;

    public static void track(@NotNull Project project, @NotNull Analytics analytics) {
        if (project == null) {
            ToolWindowTracker.$$$reportNull$$$0(0);
        }
        if (analytics == null) {
            ToolWindowTracker.$$$reportNull$$$0(1);
        }
        new ToolWindowTracker(project, analytics);
    }

    private ToolWindowTracker(@NotNull Project project, @NotNull Analytics analytics) {
        if (project == null) {
            ToolWindowTracker.$$$reportNull$$$0(2);
        }
        if (analytics == null) {
            ToolWindowTracker.$$$reportNull$$$0(3);
        }
        this.myAnalytics = analytics;
        this.myToolWindowManager = ToolWindowManagerEx.getInstanceEx((Project)project);
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)this);
        this.update();
    }

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
        if (toolWindowManager == null) {
            ToolWindowTracker.$$$reportNull$$$0(4);
        }
        this.update();
    }

    private void update() {
        String newWindow = this.findWindowId();
        if (!StringUtil.equals((CharSequence)newWindow, (CharSequence)this.currentWindowId)) {
            this.currentWindowId = newWindow;
            this.myAnalytics.sendScreenView(this.currentWindowId);
        }
    }

    @NotNull
    private String findWindowId() {
        String newWindow = this.myToolWindowManager.getActiveToolWindowId();
        String string = newWindow == null ? "editor" : newWindow.toLowerCase();
        if (string == null) {
            ToolWindowTracker.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analytics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/analytics/ToolWindowTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/analytics/ToolWindowTracker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "track";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stateChanged";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

