/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ReflectionUtil;
import io.flutter.FlutterMessages;
import io.flutter.android.AndroidSdk;
import io.flutter.utils.MostlySilentColoredProcessHandler;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class AndroidEmulator {
    private static final Logger LOG = Logger.getInstance(AndroidEmulator.class);
    @NotNull
    final AndroidSdk androidSdk;
    @NotNull
    final String id;
    ProcessAdapter listener;

    AndroidEmulator(@NotNull AndroidSdk androidSdk, @NotNull String id) {
        if (androidSdk == null) {
            AndroidEmulator.$$$reportNull$$$0(0);
        }
        if (id == null) {
            AndroidEmulator.$$$reportNull$$$0(1);
        }
        this.androidSdk = androidSdk;
        this.id = id;
    }

    public String getName() {
        return this.id.replaceAll("_", " ");
    }

    public void startEmulator() {
        if (this.androidSdk.project.isDisposed()) {
            return;
        }
        VirtualFile emulator = this.androidSdk.getEmulatorToolExecutable();
        if (emulator == null) {
            FlutterMessages.showError("Error Opening Emulator", "Unable to locate the emulator tool in the Android SDK.", this.androidSdk.project);
            return;
        }
        String emulatorPath = emulator.getCanonicalPath();
        assert (emulatorPath != null);
        GeneralCommandLine cmd = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(this.androidSdk.getHome().getCanonicalPath()).withExePath(emulatorPath).withParameters(new String[]{"-avd", this.id});
        final boolean shouldLaunchEmulatorInToolWindow = this.getLaunchInToolWindow();
        if (shouldLaunchEmulatorInToolWindow) {
            cmd.addParameter("-qt-hide-window");
            cmd.addParameter("-grpc-use-token");
            cmd.addParameters(new String[]{"-idle-grpc-timeout", "300"});
        }
        try {
            final StringBuilder stdout = new StringBuilder();
            final MostlySilentColoredProcessHandler process = new MostlySilentColoredProcessHandler(cmd);
            this.listener = new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (AndroidEmulator.this.androidSdk.project.isDisposed()) {
                        return;
                    }
                    if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.STDOUT) {
                        stdout.append(event.getText());
                    }
                    AndroidEmulator.this.openEmulatorToolWindow(shouldLaunchEmulatorInToolWindow);
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    process.removeProcessListener((ProcessListener)AndroidEmulator.this.listener);
                    int exitCode = event.getExitCode();
                    if (exitCode != 0) {
                        String message = stdout.isEmpty() ? "Android emulator terminated with exit code " + exitCode : stdout.toString().trim();
                        FlutterMessages.showError("Error Opening Emulator", message, AndroidEmulator.this.androidSdk.project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "io/flutter/android/AndroidEmulator$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            process.addProcessListener((ProcessListener)this.listener);
            process.startNotify();
        }
        catch (ExecutionException | RuntimeException e) {
            FlutterMessages.showError("Error Opening Emulator", e.toString(), this.androidSdk.project);
        }
    }

    private void openEmulatorToolWindow(boolean shouldLaunchEmulatorInToolWindow) {
        if (!shouldLaunchEmulatorInToolWindow) {
            return;
        }
        if (this.androidSdk.project.isDisposed()) {
            return;
        }
        ToolWindowManager wm = ToolWindowManager.getInstance((Project)this.androidSdk.project);
        ToolWindow tw = wm.getToolWindow("Android Emulator");
        if (tw == null || tw.isVisible()) {
            return;
        }
        assert (ApplicationManager.getApplication() != null);
        ApplicationManager.getApplication().invokeLater(() -> {
            tw.setAutoHide(false);
            tw.show();
        }, ModalityState.stateForComponent((Component)tw.getComponent()));
    }

    public boolean equals(Object obj) {
        return obj instanceof AndroidEmulator && ((AndroidEmulator)obj).id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private boolean getLaunchInToolWindow() {
        Class<?> aClass;
        try {
            aClass = Class.forName("com.android.tools.idea.emulator.EmulatorSettings");
        }
        catch (ClassNotFoundException e) {
            try {
                aClass = Class.forName("com.android.tools.idea.streaming.EmulatorSettings");
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        Method method = ReflectionUtil.getDeclaredMethod(aClass, (String)"getInstance", (Class[])new Class[0]);
        try {
            Object instance = method.invoke(null, new Object[0]);
            Method option = ReflectionUtil.getDeclaredMethod(aClass, (String)"getLaunchInToolWindow", (Class[])new Class[0]);
            return (Boolean)option.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "androidSdk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "id";
                break;
            }
        }
        objectArray[1] = "io/flutter/android/AndroidEmulator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

