/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterUtils;
import io.flutter.android.AndroidEmulator;
import io.flutter.android.IntelliJAndroidSdk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdk {
    private static final Logger LOG = Logger.getInstance(AndroidSdk.class);
    @NotNull
    Project project;
    @NotNull
    private final VirtualFile home;

    @Nullable
    public static AndroidSdk createFromProject(@NotNull Project project) {
        String sdkPath;
        if (project == null) {
            AndroidSdk.$$$reportNull$$$0(0);
        }
        if ((sdkPath = IntelliJAndroidSdk.chooseAndroidHome(project, true)) == null) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(sdkPath);
        if (file == null) {
            return null;
        }
        return new AndroidSdk(project, file);
    }

    AndroidSdk(@NotNull Project project, @NotNull VirtualFile home) {
        if (project == null) {
            AndroidSdk.$$$reportNull$$$0(1);
        }
        if (home == null) {
            AndroidSdk.$$$reportNull$$$0(2);
        }
        this.project = project;
        this.home = home;
    }

    @NotNull
    public VirtualFile getHome() {
        VirtualFile virtualFile = this.home;
        if (virtualFile == null) {
            AndroidSdk.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getEmulatorToolExecutable() {
        VirtualFile file = this.home.findFileByRelativePath("emulator/" + (SystemInfo.isWindows ? "emulator.exe" : "emulator"));
        if (file != null) {
            return file;
        }
        return this.home.findFileByRelativePath("tools/" + (SystemInfo.isWindows ? "emulator.exe" : "emulator"));
    }

    @NotNull
    public List<AndroidEmulator> getEmulators() {
        ArrayList<AndroidEmulator> arrayList;
        StringBuilder stringBuilder;
        block13: {
            ColoredProcessHandler process;
            block12: {
                VirtualFile emulator = this.getEmulatorToolExecutable();
                if (emulator == null) {
                    List<AndroidEmulator> list = Collections.emptyList();
                    if (list == null) {
                        AndroidSdk.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                String emulatorPath = emulator.getCanonicalPath();
                assert (emulatorPath != null);
                GeneralCommandLine cmd = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(this.home.getCanonicalPath()).withExePath(emulatorPath).withParameters(new String[]{"-list-avds"});
                stringBuilder = new StringBuilder();
                process = new ColoredProcessHandler(cmd);
                process.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            stringBuilder.append(event.getText());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "io/flutter/android/AndroidSdk$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                process.startNotify();
                if (process.waitFor(10000L)) break block12;
                List<AndroidEmulator> list = Collections.emptyList();
                if (list == null) {
                    AndroidSdk.$$$reportNull$$$0(5);
                }
                return list;
            }
            Integer exitCode = process.getExitCode();
            if (exitCode != null && process.getExitCode() == 0) break block13;
            List<AndroidEmulator> list = Collections.emptyList();
            if (list == null) {
                AndroidSdk.$$$reportNull$$$0(6);
            }
            return list;
        }
        try {
            ArrayList<AndroidEmulator> emulators = new ArrayList<AndroidEmulator>();
            for (String str : stringBuilder.toString().split("\n")) {
                if ((str = str.trim()).isEmpty()) continue;
                emulators.add(new AndroidEmulator(this, str));
            }
            arrayList = emulators;
        }
        catch (ExecutionException | RuntimeException e) {
            FlutterUtils.warn(LOG, "Error listing android emulators", e);
            List<AndroidEmulator> list = Collections.emptyList();
            if (list == null) {
                AndroidSdk.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (arrayList == null) {
            AndroidSdk.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/android/AndroidSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/android/AndroidSdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHome";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

