/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.bazel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginConfig {
    @NotNull
    private final Fields fields;
    private static final Gson GSON = new Gson();
    private static final Logger LOG = Logger.getInstance(PluginConfig.class);

    private PluginConfig(@NotNull Fields fields) {
        if (fields == null) {
            PluginConfig.$$$reportNull$$$0(0);
        }
        this.fields = fields;
    }

    @Nullable
    String getDaemonScript() {
        return this.fields.daemonScript;
    }

    @Nullable
    String getDevToolsScript() {
        return this.fields.devToolsScript;
    }

    @Nullable
    String getDoctorScript() {
        return this.fields.doctorScript;
    }

    @Nullable
    String getTestScript() {
        return this.fields.testScript;
    }

    @Nullable
    String getRunScript() {
        return this.fields.runScript;
    }

    @Nullable
    String getSyncScript() {
        return this.fields.syncScript;
    }

    @Nullable
    String getToolsScript() {
        return this.fields.toolsScript;
    }

    @Nullable
    String getSdkHome() {
        return this.fields.sdkHome;
    }

    @Nullable
    String getRequiredIJPluginID() {
        return this.fields.requiredIJPluginID;
    }

    @Nullable
    String getRequiredIJPluginMessage() {
        return this.fields.requiredIJPluginMessage;
    }

    @Nullable
    String getConfigWarningPrefix() {
        return this.fields.configWarningPrefix;
    }

    @Nullable
    String getUpdatedIosRunMessage() {
        return this.fields.updatedIosRunMessage;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginConfig)) {
            return false;
        }
        PluginConfig other = (PluginConfig)obj;
        return Objects.equal((Object)this.fields, (Object)other.fields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fields});
    }

    @Nullable
    public static PluginConfig load(@NotNull VirtualFile file) {
        if (file == null) {
            PluginConfig.$$$reportNull$$$0(1);
        }
        Computable readAction = () -> {
            PluginConfig pluginConfig;
            InputStreamReader input = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            try {
                Fields fields = (Fields)GSON.fromJson((Reader)input, Fields.class);
                pluginConfig = new PluginConfig(fields);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    LOG.info("Flutter plugin didn't find flutter.json at " + file.getPath());
                    return null;
                }
                catch (IOException e) {
                    FlutterUtils.warn(LOG, "Flutter plugin failed to load config file at " + file.getPath(), e);
                    return null;
                }
                catch (JsonSyntaxException e) {
                    FlutterUtils.warn(LOG, "Flutter plugin failed to parse JSON in config file at " + file.getPath());
                    return null;
                }
                catch (PatternSyntaxException e) {
                    FlutterUtils.warn(LOG, "Flutter plugin failed to parse directory pattern (" + e.getPattern() + ") in config file at " + file.getPath());
                    return null;
                }
            }
            input.close();
            return pluginConfig;
        };
        return (PluginConfig)ApplicationManager.getApplication().runReadAction(readAction);
    }

    @VisibleForTesting
    public static PluginConfig forTest(@Nullable String daemonScript, @Nullable String devToolsScript, @Nullable String doctorScript, @Nullable String testScript, @Nullable String runScript, @Nullable String syncScript, @Nullable String toolsScript, @Nullable String sdkHome, @Nullable String requiredIJPluginID, @Nullable String requiredIJPluginMessage, @Nullable String configWarningPrefix, @Nullable String updatedIosRunMessage) {
        Fields fields = new Fields(daemonScript, devToolsScript, doctorScript, testScript, runScript, syncScript, toolsScript, sdkHome, requiredIJPluginID, requiredIJPluginMessage, configWarningPrefix, updatedIosRunMessage);
        return new PluginConfig(fields);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "io/flutter/bazel/PluginConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Fields {
        @SerializedName(value="daemonScript")
        private String daemonScript;
        @SerializedName(value="devToolsScript")
        private String devToolsScript;
        @SerializedName(value="doctorScript")
        private String doctorScript;
        @SerializedName(value="testScript")
        private String testScript;
        @SerializedName(value="runScript")
        private String runScript;
        @SerializedName(value="syncScript")
        private String syncScript;
        @SerializedName(value="toolsScript")
        private String toolsScript;
        @SerializedName(value="sdkHome")
        private String sdkHome;
        @SerializedName(value="requiredIJPluginID")
        private String requiredIJPluginID;
        @SerializedName(value="requiredIJPluginMessage")
        private String requiredIJPluginMessage;
        @SerializedName(value="configWarningPrefix")
        private String configWarningPrefix;
        @SerializedName(value="updatedIosRunMessage")
        private String updatedIosRunMessage;

        Fields() {
        }

        Fields(String daemonScript, String devToolsScript, String doctorScript, String testScript, String runScript, String syncScript, String toolsScript, String sdkHome, String requiredIJPluginID, String requiredIJPluginMessage, String configWarningPrefix, String updatedIosRunMessage) {
            this.daemonScript = daemonScript;
            this.devToolsScript = devToolsScript;
            this.doctorScript = doctorScript;
            this.testScript = testScript;
            this.runScript = runScript;
            this.syncScript = syncScript;
            this.toolsScript = toolsScript;
            this.sdkHome = sdkHome;
            this.requiredIJPluginID = requiredIJPluginID;
            this.requiredIJPluginMessage = requiredIJPluginMessage;
            this.configWarningPrefix = configWarningPrefix;
            this.updatedIosRunMessage = updatedIosRunMessage;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Fields)) {
                return false;
            }
            Fields other = (Fields)obj;
            return Objects.equal((Object)this.daemonScript, (Object)other.daemonScript) && Objects.equal((Object)this.devToolsScript, (Object)other.devToolsScript) && Objects.equal((Object)this.doctorScript, (Object)other.doctorScript) && Objects.equal((Object)this.testScript, (Object)other.testScript) && Objects.equal((Object)this.runScript, (Object)other.runScript) && Objects.equal((Object)this.syncScript, (Object)other.syncScript) && Objects.equal((Object)this.sdkHome, (Object)other.sdkHome) && Objects.equal((Object)this.requiredIJPluginID, (Object)other.requiredIJPluginID) && Objects.equal((Object)this.requiredIJPluginMessage, (Object)other.requiredIJPluginMessage) && Objects.equal((Object)this.configWarningPrefix, (Object)other.configWarningPrefix) && Objects.equal((Object)this.updatedIosRunMessage, (Object)other.updatedIosRunMessage);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.daemonScript, this.devToolsScript, this.doctorScript, this.testScript, this.runScript, this.syncScript, this.sdkHome, this.requiredIJPluginID, this.requiredIJPluginMessage, this.configWarningPrefix, this.updatedIosRunMessage});
        }
    }
}

